/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.Namespaces;
import org.apache.aries.blueprint.container.BlueprintContainerImpl;
import org.apache.aries.blueprint.container.SimpleNamespaceHandlerSet;
import org.apache.aries.blueprint.parser.NamespaceHandlerSet;

public class BlueprintContextListener
implements ServletContextListener {
    public static final String CONTAINER_ATTRIBUTE = "org.apache.aries.blueprint.container";
    public static final String CONTEXT_LOCATION = "blueprintLocation";
    public static final String DEFAULT_CONTEXT_LOCATION = "META-INF/blueprint.xml";
    public static final String NAMESPACE_HANDLERS_PARAMETER = "blueprintNamespaceHandlers";
    public static final String NAMESPACE_HANDLERS_LOCATION = "META-INF/blueprint.handlers";
    public static final String PROPERTIES = "blueprintProperties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String location = servletContext.getInitParameter(CONTEXT_LOCATION);
        if (location == null) {
            location = DEFAULT_CONTEXT_LOCATION;
        }
        ArrayList<URL> resourcePaths = new ArrayList<URL>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources(location);
            while (resources.hasMoreElements()) {
                resourcePaths.add(resources.nextElement());
            }
            servletContext.log("Loading Blueprint contexts " + resourcePaths);
            HashMap<String, String> properties = new HashMap<String, String>();
            String propLocations = servletContext.getInitParameter(PROPERTIES);
            if (propLocations != null) {
                for (String propLoc : propLocations.split(",")) {
                    Enumeration<URL> propUrl = classLoader.getResources(propLoc);
                    while (propUrl.hasMoreElements()) {
                        URL url = propUrl.nextElement();
                        InputStream is = url.openStream();
                        try {
                            Properties props = new Properties();
                            props.load(is);
                            Enumeration<?> names = props.propertyNames();
                            while (names.hasMoreElements()) {
                                String key = names.nextElement().toString();
                                properties.put(key, props.getProperty(key));
                            }
                        }
                        finally {
                            is.close();
                        }
                    }
                }
            }
            NamespaceHandlerSet nsHandlerSet = this.getNamespaceHandlerSet(servletContext, classLoader);
            BlueprintContainerImpl container = new BlueprintContainerImpl(classLoader, resourcePaths, properties, nsHandlerSet, true);
            servletContext.setAttribute(CONTAINER_ATTRIBUTE, (Object)container);
        }
        catch (Exception e) {
            servletContext.log("Failed to startup blueprint container. " + e, (Throwable)e);
        }
    }

    protected NamespaceHandlerSet getNamespaceHandlerSet(ServletContext servletContext, ClassLoader tccl) {
        NamespaceHandlerSet nsSet = this.getNamespaceHandlerSetFromParameter(servletContext, tccl);
        if (nsSet != null) {
            return nsSet;
        }
        return this.getNamespaceHandlerSetFromLocation(servletContext, tccl);
    }

    protected NamespaceHandlerSet getNamespaceHandlerSetFromParameter(ServletContext servletContext, ClassLoader tccl) {
        String handlersProp = servletContext.getInitParameter(NAMESPACE_HANDLERS_PARAMETER);
        if (handlersProp == null) {
            return null;
        }
        return this.getNamespaceHandlerSetFromClassNames(servletContext, tccl, Arrays.asList(handlersProp.split(",")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamespaceHandlerSet getNamespaceHandlerSetFromLocation(ServletContext servletContext, ClassLoader tccl) {
        LinkedList<String> handlerClassNames = new LinkedList<String>();
        try {
            Enumeration<URL> resources = tccl.getResources(NAMESPACE_HANDLERS_LOCATION);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                BufferedReader br = new BufferedReader(new InputStreamReader(resource.openStream()));
                try {
                    String line = br.readLine();
                    while (line != null) {
                        String trimmedLine = line.trim();
                        if (!trimmedLine.isEmpty() && !trimmedLine.startsWith("#")) {
                            handlerClassNames.add(trimmedLine);
                        }
                        line = br.readLine();
                    }
                }
                finally {
                    br.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load namespace handler resources", ex);
        }
        if (!handlerClassNames.isEmpty()) {
            return this.getNamespaceHandlerSetFromClassNames(servletContext, tccl, handlerClassNames);
        }
        return null;
    }

    protected NamespaceHandlerSet getNamespaceHandlerSetFromClassNames(ServletContext servletContext, ClassLoader tccl, List<String> handlerClassNames) {
        SimpleNamespaceHandlerSet nsSet = new SimpleNamespaceHandlerSet();
        for (String name : handlerClassNames) {
            String trimmedName = name.trim();
            Object instance = null;
            try {
                instance = tccl.loadClass(trimmedName).newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to load NamespaceHandler: " + trimmedName, ex);
            }
            if (!(instance instanceof NamespaceHandler)) {
                throw new RuntimeException("Invalid NamespaceHandler: " + trimmedName);
            }
            NamespaceHandler nsHandler = instance;
            Namespaces namespaces = nsHandler.getClass().getAnnotation(Namespaces.class);
            if (namespaces == null) continue;
            for (String ns : namespaces.value()) {
                nsSet.addNamespace(URI.create(ns), nsHandler.getSchemaLocation(ns), nsHandler);
            }
        }
        return nsSet;
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        Object container = servletContext.getAttribute(CONTAINER_ATTRIBUTE);
        if (container instanceof BlueprintContainerImpl) {
            BlueprintContainerImpl blueprint = (BlueprintContainerImpl)container;
            blueprint.destroy();
        }
    }
}

