/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.codec.PropertyData;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleData {
    protected String name;
    protected int type;

    public RoleData(Role role) {
        this(role.getName(), role.getType());
    }

    public RoleData(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("Name", this.name);
            items.put("Type", this.type);
            return new CompositeDataSupport(UserAdminMBean.ROLE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    public static RoleData from(CompositeData data) {
        if (data == null) {
            return null;
        }
        String name = (String)data.get("Name");
        int type = (Integer)data.get("Type");
        return new RoleData(name, type);
    }

    protected static TabularData toTabularData(Dictionary<String, Object> props) {
        if (props == null) {
            return null;
        }
        TabularDataSupport data = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            data.put(PropertyData.newInstance(key, props.get(key)).toCompositeData());
        }
        return data;
    }

    protected static Dictionary<String, Object> propertiesFrom(TabularData data) {
        if (data == null) {
            return null;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (CompositeData compositeData : data.values()) {
            PropertyData property = PropertyData.from(compositeData);
            ((Dictionary)props).put(property.getKey(), property.getValue());
        }
        return props;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }
}

