/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.blueprint.aries.impl;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.aries.jpa.container.context.PersistenceContextProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSHandler
implements NamespaceHandler {
    private static final String ATTR_INDEX = "index";
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.blueprint.aries");
    public static final String NS_URI_100 = "http://aries.apache.org/xmlns/jpa/v1.0.0";
    public static final String NS_URI_110 = "http://aries.apache.org/xmlns/jpa/v1.1.0";
    private static final String BLUEPRINT_NS = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    private static final String TAG_UNIT = "unit";
    private static final String TAG_CONTEXT = "context";
    private static final String TAG_MAP = "map";
    private static final String ATTR_PROPERTY = "property";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_UNIT_NAME = "unitname";
    private static final String DEFAULT_UNIT_NAME = "";
    public static final String EMPTY_UNIT_NAME_FILTER = "(org.apache.aries.jpa.default.unit.name=true)";
    private static final String ACTIVATION_EAGER = "EAGER";
    private PersistenceContextProvider manager;
    private final AtomicBoolean contextsAvailable = new AtomicBoolean();

    public void setManager(PersistenceContextProvider manager) {
        this.manager = manager;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        if (node.getNodeType() != 1) {
            _logger.error("The JPA namespace handler does not understand the DOM node {}.", new Object[]{node});
            throw new IllegalArgumentException(node.toString());
        }
        Element element = (Element)node;
        if (!(component instanceof BeanMetadata)) {
            _logger.error("The JPA namespace should only be used to inject properties or constuctor arguments into a bean. The surrounding component was {}.", new Object[]{component});
            throw new IllegalArgumentException(component.toString());
        }
        if (!(component instanceof MutableBeanMetadata)) {
            _logger.error("The JPA namespace should only be used to inject properties into beans that implement the MutableBeanMetadata interface. The surrounding component was {}.", new Object[]{component});
            throw new IllegalArgumentException(component.toString());
        }
        MutableBeanMetadata bean = (MutableBeanMetadata)component;
        if (!NS_URI_100.equals(element.getNamespaceURI()) && !NS_URI_110.equals(element.getNamespaceURI())) {
            _logger.error("The JPA namespace handler should not be called for the namespace {}.", new Object[]{element.getNamespaceURI()});
            throw new IllegalArgumentException("The JPA namespace handler should not be called for the namespace " + element.getNamespaceURI());
        }
        if (!TAG_UNIT.equals(element.getLocalName()) && !TAG_CONTEXT.equals(element.getLocalName())) {
            _logger.error("The JPA namespace handler did not recognize the element named {}.", new Object[]{element.getLocalName()});
            throw new IllegalArgumentException("The JPA namespace handler did not recognize the element named " + element.getLocalName());
        }
        String property = element.getAttribute(ATTR_PROPERTY);
        property = property.isEmpty() ? null : property;
        String index = element.getAttribute(ATTR_INDEX);
        String string = index = index.isEmpty() ? null : index;
        if (property != null && index != null) {
            _logger.error("It is invalid to specify a bean property and an index");
        } else if (property != null) {
            BeanProperty beanProperty = this.createBeanProperty(element, property, TAG_UNIT.equals(element.getLocalName()), context);
            bean.addProperty(beanProperty);
        } else {
            BeanArgument argument = this.createArgument(element, index, TAG_UNIT.equals(element.getLocalName()), context);
            bean.addArgument(argument);
        }
        if (TAG_CONTEXT.equals(element.getLocalName())) {
            Bundle client = this.getBlueprintBundle(context);
            String unitName = this.parseUnitName(element);
            if (client != null) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("org.apache.aries.jpa.context.type", this.parseType(element));
                properties.putAll(this.parseJPAProperties(element, context));
                if (this.contextsAvailable.get()) {
                    this.manager.registerContext(unitName, client, properties);
                } else {
                    _logger.warn("The bundle {} is a client of persistence unit {} with properties {}, but no PersistenceContextProvider is available in the runtime. The blueprint for this bundle will not start correctly unless the managed persistence context is registered through some other mechanism", new Object[]{client.getSymbolicName() + "_" + client.getVersion(), unitName, properties});
                }
            } else {
                _logger.debug("No bundle: this must be a dry, parse only run.");
            }
        }
        return bean;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public URL getSchemaLocation(String namespace) {
        if (NS_URI_100.equals(namespace)) {
            return this.getClass().getResource("/org/apache/aries/jpa/blueprint/namespace/jpa.xsd");
        }
        if (NS_URI_110.equals(namespace)) {
            return this.getClass().getResource("/org/apache/aries/jpa/blueprint/namespace/jpa_110.xsd");
        }
        return null;
    }

    public Metadata parse(Element element, ParserContext context) {
        _logger.error("The JPA namespace handler was called to parse a top level element.");
        throw new UnsupportedOperationException();
    }

    public void contextAvailable(ServiceReference ref) {
        boolean log = this.contextsAvailable.compareAndSet(false, true);
        if (log && _logger.isDebugEnabled()) {
            _logger.debug("Managed persistence context support is now available for use with the Aries Blueprint container");
        }
    }

    public void contextUnavailable(ServiceReference ref) {
        this.contextsAvailable.set(false);
        _logger.warn("Managed persistence context support is no longer available for use with the Aries Blueprint container");
    }

    private BeanProperty createBeanProperty(Element element, final String property, boolean isPersistenceUnit, ParserContext ctx) {
        String unitName = this.parseUnitName(element);
        if (_logger.isDebugEnabled()) {
            if (isPersistenceUnit) {
                _logger.debug("Creating blueprint injection metadata to inject the unit {} into bean property {}", new Object[]{unitName, property});
            } else {
                _logger.debug("Creating blueprint injection metadata to inject the context {} into bean property {}", new Object[]{unitName, property});
            }
        }
        final Metadata target = this.createTargetMetadata(isPersistenceUnit, ctx, unitName);
        return new BeanProperty(){

            public Metadata getValue() {
                return target;
            }

            public String getName() {
                return property;
            }
        };
    }

    private BeanArgument createArgument(Element element, String index, final boolean isPersistenceUnit, ParserContext ctx) {
        int i;
        String unitName = this.parseUnitName(element);
        if (_logger.isDebugEnabled()) {
            if (isPersistenceUnit) {
                if (index == null) {
                    _logger.debug("Creating blueprint injection metadata to inject the unit {} as a constructor argument", new Object[]{unitName});
                } else {
                    _logger.debug("Creating blueprint injection metadata to inject the unit {} as a constructor argument with index {}", new Object[]{unitName, index});
                }
            } else if (index == null) {
                _logger.debug("Creating blueprint injection metadata to inject the context {} as a constructor argument", new Object[]{unitName});
            } else {
                _logger.debug("Creating blueprint injection metadata to inject the context {} as a constructor argument with index {}", new Object[]{unitName, index});
            }
        }
        if (index == null) {
            i = -1;
        } else {
            try {
                i = Integer.parseInt(index);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("The string " + index + " could not be parsed as an index.", nfe);
            }
        }
        final Metadata target = this.createTargetMetadata(isPersistenceUnit, ctx, unitName);
        return new BeanArgument(){

            public Metadata getValue() {
                return target;
            }

            public String getValueType() {
                return isPersistenceUnit ? "javax.persistence.EntityManagerFactory" : "javax.persistence.EntityManager";
            }

            public int getIndex() {
                return i;
            }
        };
    }

    private Metadata createTargetMetadata(boolean isPersistenceUnit, ParserContext ctx, String unitName) {
        MutableReferenceMetadata refMetadata = (MutableReferenceMetadata)ctx.createMetadata(ReferenceMetadata.class);
        refMetadata.setActivation(ACTIVATION_EAGER.equalsIgnoreCase(ctx.getDefaultActivation()) ? 1 : 2);
        refMetadata.setAvailability(1);
        refMetadata.setInterface(EntityManagerFactory.class.getName());
        StringBuilder filter = new StringBuilder("(&");
        if (isPersistenceUnit) {
            filter.append("(!(").append("org.apache.aries.jpa.proxy.factory").append("=*))");
        } else {
            filter.append("(").append("org.apache.aries.jpa.proxy.factory").append("=true)");
        }
        if (!DEFAULT_UNIT_NAME.equals(unitName)) {
            filter.append("(osgi.unit.name=" + unitName + ")");
        } else {
            filter.append(EMPTY_UNIT_NAME_FILTER);
        }
        filter.append(")");
        refMetadata.setFilter(filter.toString());
        refMetadata.setTimeout((long)Integer.parseInt(ctx.getDefaultTimeout()));
        refMetadata.setDependsOn(Collections.EMPTY_LIST);
        refMetadata.setId(ctx.generateId());
        MutableReferenceMetadata target = isPersistenceUnit ? refMetadata : this.createInjectionBeanMetedata(ctx, (ReferenceMetadata)refMetadata);
        return target;
    }

    private Metadata createInjectionBeanMetedata(ParserContext ctx, ReferenceMetadata factory) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Creating a managed persistence context definition for injection");
        }
        ctx.getComponentDefinitionRegistry().registerComponentDefinition((ComponentMetadata)factory);
        MutableBeanMetadata meta = (MutableBeanMetadata)ctx.createMetadata(BeanMetadata.class);
        MutableRefMetadata ref = (MutableRefMetadata)ctx.createMetadata(RefMetadata.class);
        ref.setComponentId(factory.getId());
        meta.setFactoryComponent((Target)ref);
        meta.setActivation(factory.getActivation());
        meta.setFactoryMethod("createEntityManager");
        meta.setScope("prototype");
        meta.setDestroyMethod("internalClose");
        return meta;
    }

    private Bundle getBlueprintBundle(ParserContext context) {
        PassThroughMetadata metadata = (PassThroughMetadata)context.getComponentDefinitionRegistry().getComponentDefinition("blueprintBundle");
        Bundle result = null;
        if (metadata != null) {
            result = (Bundle)metadata.getObject();
        }
        return result;
    }

    private PersistenceContextType parseType(Element element) {
        if (element.hasAttribute(ATTR_TYPE)) {
            return PersistenceContextType.valueOf((String)element.getAttribute(ATTR_TYPE));
        }
        return PersistenceContextType.TRANSACTION;
    }

    private String parseUnitName(Element element) {
        return element.hasAttribute(ATTR_UNIT_NAME) ? element.getAttribute(ATTR_UNIT_NAME) : DEFAULT_UNIT_NAME;
    }

    private Map<String, Object> parseJPAProperties(Element element, ParserContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        NodeList ns = element.getElementsByTagNameNS(BLUEPRINT_NS, TAG_MAP);
        for (int i = 0; i < ns.getLength(); ++i) {
            MapMetadata metadata = (MapMetadata)context.parseElement(MapMetadata.class, null, (Element)ns.item(i));
            for (MapEntry entry : metadata.getEntries()) {
                if (entry.getKey() instanceof ValueMetadata && entry.getValue() instanceof ValueMetadata) {
                    ValueMetadata key = (ValueMetadata)entry.getKey();
                    ValueMetadata value = (ValueMetadata)entry.getValue();
                    result.put(key.getStringValue(), value.getStringValue());
                    continue;
                }
                _logger.error("There was a problem parsing a map of JPA properties");
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }
}

