/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptor;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptorParser;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptorParserException;
import org.apache.aries.jpa.container.parsing.impl.EarlyParserReturn;
import org.apache.aries.jpa.container.parsing.impl.JPAHandler;
import org.apache.aries.jpa.container.parsing.impl.SchemaLocatingHandler;
import org.osgi.framework.Bundle;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceDescriptorParserImpl
implements PersistenceDescriptorParser {
    @Override
    public Collection<ParsedPersistenceUnit> parse(Bundle b, PersistenceDescriptor descriptor) throws PersistenceDescriptorParserException {
        ArrayList<ParsedPersistenceUnit> persistenceUnits = new ArrayList<ParsedPersistenceUnit>();
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        RememberingInputStream is = null;
        boolean schemaFound = false;
        try {
            is = new RememberingInputStream(descriptor.getInputStream());
            ((InputStream)is).mark(Integer.MAX_VALUE);
            SAXParser parser = parserFactory.newSAXParser();
            try {
                parser.parse((InputStream)is, (DefaultHandler)new SchemaLocatingHandler());
            }
            catch (EarlyParserReturn epr) {
                Schema s = epr.getSchema();
                if (s != null) {
                    schemaFound = true;
                    parserFactory.setSchema(s);
                    parserFactory.setNamespaceAware(true);
                    parser = parserFactory.newSAXParser();
                    ((InputStream)is).reset();
                    JPAHandler handler = new JPAHandler(b, epr.getVersion());
                    parser.parse((InputStream)is, (DefaultHandler)handler);
                    persistenceUnits.addAll(handler.getPersistenceUnits());
                }
            }
        }
        catch (Exception e) {
            throw new PersistenceDescriptorParserException("There was an error parsing " + descriptor.getLocation() + " in bundle " + b.getSymbolicName() + "_" + b.getVersion(), e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        if (!schemaFound) {
            throw new PersistenceDescriptorParserException("No Schema could be located for thepersistence descriptor " + descriptor.getLocation() + " in bundle " + b.getSymbolicName() + "_" + b.getVersion());
        }
        return persistenceUnits;
    }

    private static class RememberingInputStream
    extends InputStream {
        private static final int bufferGrowthSize = 16384;
        private byte[] bytes = new byte[16384];
        private int pos = 0;
        private final InputStream stream;
        private int maxRead = -1;
        private int markPoint = -1;

        public RememberingInputStream(InputStream in) throws IOException {
            this.stream = in;
            this.maxRead = this.stream.read(this.bytes) - 1;
        }

        public int read() throws IOException {
            if (this.pos <= this.maxRead) {
                return this.bytes[this.pos++] & 0xFF;
            }
            int i = this.stream.read();
            if (i < 0) {
                return i;
            }
            this.ensureCapacity(0);
            this.bytes[this.pos++] = (byte)i;
            return i;
        }

        private void ensureCapacity(int i) {
            if (this.pos + i >= this.bytes.length) {
                int newLength;
                byte[] tmp = this.bytes;
                for (newLength = this.bytes.length + 16384; newLength < this.pos + i; newLength += 16384) {
                }
                this.bytes = new byte[newLength];
                System.arraycopy(tmp, 0, this.bytes, 0, this.maxRead >= this.pos ? this.maxRead + 1 : this.pos);
            }
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.pos <= this.maxRead) {
                if (this.pos + len <= this.maxRead) {
                    System.arraycopy(this.bytes, this.pos, b, off, len);
                    this.pos += len;
                    return len;
                }
                int lengthLeftOfBuffer = this.maxRead - this.pos + 1;
                System.arraycopy(this.bytes, this.pos, b, off, lengthLeftOfBuffer);
                int read = this.stream.read(b, off + lengthLeftOfBuffer, len - lengthLeftOfBuffer);
                if (read < 0) {
                    this.pos += lengthLeftOfBuffer;
                    return lengthLeftOfBuffer;
                }
                this.ensureCapacity(lengthLeftOfBuffer + read - 1);
                System.arraycopy(b, off + lengthLeftOfBuffer, this.bytes, this.maxRead + 1, read);
                this.pos += lengthLeftOfBuffer + read;
                return lengthLeftOfBuffer + read;
            }
            int i = this.stream.read(b, off, len);
            if (i < 0) {
                return i;
            }
            this.ensureCapacity(i - 1);
            System.arraycopy(b, off, this.bytes, this.pos, i);
            this.pos += i;
            return i;
        }

        public long skip(long n) throws IOException {
            throw new IOException("Skip is unsupported");
        }

        public int available() throws IOException {
            if (this.pos <= this.maxRead) {
                return this.maxRead - this.pos + 1;
            }
            return this.stream.available();
        }

        public synchronized void mark(int readlimit) {
            this.markPoint = this.pos;
        }

        public synchronized void reset() throws IOException {
            if (this.maxRead < this.pos) {
                this.maxRead = this.pos - 1;
            }
            this.pos = this.markPoint;
        }

        public boolean markSupported() {
            return true;
        }

        public void close() throws IOException {
        }
    }
}

