/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.tx.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.tx.impl.ConnectionKey;
import org.apache.aries.jpa.container.tx.impl.ConnectionWrapper;
import org.apache.aries.jpa.container.tx.impl.OSGiTransactionManager;
import org.osgi.framework.FrameworkUtil;

public class XADatasourceEnlistingWrapper
implements DataSource,
Serializable {
    private static final long serialVersionUID = -3200389791205501228L;
    private final XADataSource wrappedDS;
    private transient Map<Object, Connection> connectionMap = new ConcurrentHashMap<Object, Connection>();

    public XADatasourceEnlistingWrapper(XADataSource toWrap) {
        this.wrappedDS = toWrap;
        OSGiTransactionManager.init(FrameworkUtil.getBundle(XADatasourceEnlistingWrapper.class).getBundleContext());
    }

    @Override
    public Connection getConnection() throws SQLException {
        Transaction transaction = this.getTransaction();
        if (transaction != null) {
            Transaction key = transaction;
            Connection connection = this.connectionMap.get(key);
            if (connection == null) {
                XAConnection xaConnection = this.wrappedDS.getXAConnection();
                connection = xaConnection.getConnection();
                this.enlist(transaction, xaConnection.getXAResource(), key);
                this.connectionMap.put(key, connection);
            }
            return this.getEnlistedConnection(connection, true);
        }
        return this.getEnlistedConnection(this.wrappedDS.getXAConnection().getConnection(), false);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Transaction transaction = this.getTransaction();
        if (transaction != null) {
            ConnectionKey key = new ConnectionKey(username, password, transaction);
            Connection connection = this.connectionMap.get(key);
            if (connection == null) {
                XAConnection xaConnection = this.wrappedDS.getXAConnection(username, password);
                connection = xaConnection.getConnection();
                this.enlist(transaction, xaConnection.getXAResource(), key);
                this.connectionMap.put(key, connection);
            }
            return this.getEnlistedConnection(connection, true);
        }
        return this.getEnlistedConnection(this.wrappedDS.getXAConnection(username, password).getConnection(), false);
    }

    private Transaction getTransaction() throws SQLException {
        try {
            return OSGiTransactionManager.get().getStatus() == 0 ? (Transaction)OSGiTransactionManager.get().getTransaction() : null;
        }
        catch (SystemException e) {
            throw new SQLException(NLS.MESSAGES.getMessage("unable.to.get.tx", new Object[0]), e);
        }
    }

    private void enlist(Transaction transaction, XAResource xaResource, Object key) throws SQLException {
        try {
            transaction.enlistResource(xaResource);
            transaction.registerSynchronization((Synchronization)new TransactionListener(key));
        }
        catch (Exception e) {
            try {
                OSGiTransactionManager.get().setRollbackOnly();
            }
            catch (IllegalStateException e1) {
                e1.printStackTrace();
            }
            catch (SystemException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.wrappedDS.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.wrappedDS.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.wrappedDS.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.wrappedDS.setLoginTimeout(seconds);
    }

    private Connection getEnlistedConnection(Connection connection, boolean enlisted) throws SQLException {
        return new ConnectionWrapper(connection, enlisted);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.wrappedDS.equals(((XADatasourceEnlistingWrapper)other).wrappedDS);
        }
        return false;
    }

    public int hashCode() {
        return this.wrappedDS.hashCode();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    private class TransactionListener
    implements Synchronization {
        private final Object key;

        public TransactionListener(Object key) {
            this.key = key;
        }

        public void afterCompletion(int status) {
            Connection connection = (Connection)XADatasourceEnlistingWrapper.this.connectionMap.remove(this.key);
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }

        public void beforeCompletion() {
        }
    }
}

