/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.unit.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.aries.jpa.container.ManagedPersistenceUnitInfo;
import org.apache.aries.jpa.container.ManagedPersistenceUnitInfoFactory;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.apache.aries.jpa.container.unit.impl.ManagedPersistenceUnitInfoImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ManagedPersistenceUnitInfoFactoryImpl
implements ManagedPersistenceUnitInfoFactory {
    private ConcurrentMap<Bundle, Collection<ManagedPersistenceUnitInfoImpl>> persistenceUnits = new ConcurrentHashMap<Bundle, Collection<ManagedPersistenceUnitInfoImpl>>();

    public Collection<? extends ManagedPersistenceUnitInfo> createManagedPersistenceUnitMetadata(BundleContext containerContext, Bundle persistenceBundle, ServiceReference providerReference, Collection<ParsedPersistenceUnit> persistenceMetadata) {
        ArrayList<ManagedPersistenceUnitInfoImpl> managedUnits = new ArrayList<ManagedPersistenceUnitInfoImpl>();
        for (ParsedPersistenceUnit unit : persistenceMetadata) {
            managedUnits.add(new ManagedPersistenceUnitInfoImpl(persistenceBundle, unit, providerReference));
        }
        Collection existing = this.persistenceUnits.putIfAbsent(persistenceBundle, managedUnits);
        if (existing != null) {
            throw new IllegalStateException(NLS.MESSAGES.getMessage("previous.pus.have.not.been.destroyed", new Object[]{persistenceBundle.getSymbolicName(), persistenceBundle.getVersion()}));
        }
        return Collections.unmodifiableCollection(managedUnits);
    }

    public void destroyPersistenceBundle(BundleContext containerContext, Bundle bundle) {
        Collection mpus = (Collection)this.persistenceUnits.remove(bundle);
        if (mpus == null) {
            throw new IllegalStateException(NLS.MESSAGES.getMessage("no.persistence.units.for.bundle", new Object[]{bundle.getSymbolicName(), bundle.getVersion()}));
        }
        for (ManagedPersistenceUnitInfoImpl impl : mpus) {
            impl.destroy();
        }
    }

    public String getDefaultProviderClassName() {
        return null;
    }
}

