/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.unit.impl;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.aries.jpa.container.ManagedPersistenceUnitInfo;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.apache.aries.jpa.container.unit.impl.PersistenceUnitInfoImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedPersistenceUnitInfoImpl
implements ManagedPersistenceUnitInfo {
    private static final Logger _logger;
    private static final Boolean useDataSourceFactory;
    private final PersistenceUnitInfoImpl info;

    public ManagedPersistenceUnitInfoImpl(Bundle persistenceBundle, ParsedPersistenceUnit unit, ServiceReference providerRef) {
        this.info = new PersistenceUnitInfoImpl(persistenceBundle, unit, providerRef, useDataSourceFactory);
    }

    public Map<String, Object> getContainerProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("org.apache.aries.jpa.use.data.source.factory", useDataSourceFactory.toString());
        return props;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.info;
    }

    public void destroy() {
        this.info.clearUp();
    }

    public void registered() {
    }

    public void unregistered() {
        this.info.unregistered();
    }

    static {
        boolean b;
        _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");
        try {
            Class.forName("org.osgi.service.jdbc.DataSourceFactory", false, ManagedPersistenceUnitInfoImpl.class.getClassLoader());
            b = true;
        }
        catch (ClassNotFoundException cnfe) {
            if (_logger.isInfoEnabled()) {
                _logger.info(NLS.MESSAGES.getMessage("no.datasourcefactory.integration", new Object[0]));
            }
            b = false;
        }
        useDataSourceFactory = b;
    }
}

