/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.quiesce.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.aries.jpa.container.quiesce.impl.DestroyCallback;
import org.apache.aries.jpa.container.quiesce.impl.QuiesceHandler;
import org.apache.aries.quiesce.manager.QuiesceCallback;
import org.apache.aries.quiesce.participant.QuiesceParticipant;
import org.apache.aries.util.AriesFrameworkUtil;
import org.apache.aries.util.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class QuiesceParticipantImpl
implements QuiesceParticipant,
Closeable {
    private static final int QUIESCABLE_BUNDLE = 56;
    private final ExecutorService executor = new ThreadPoolExecutor(0, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "JPA-Container-ThreadPool");
            t.setDaemon(true);
            return t;
        }
    });
    private QuiesceHandler quiesceHandler;
    private final BundleContext context;
    private ServiceRegistration quiesceReg;
    private final BlockingQueue<DestroyCallback> unhandledQuiesces = new LinkedBlockingQueue<DestroyCallback>();

    public QuiesceParticipantImpl(BundleContext context, QuiesceHandler quiesceHandler) {
        this.context = context;
        this.quiesceHandler = quiesceHandler;
        context.registerService(QuiesceParticipant.class.getName(), (Object)this, null);
    }

    public void quiesce(QuiesceCallback qc, List<Bundle> arg1) {
        boolean closeSelf = false;
        for (Bundle b : arg1) {
            try {
                if ((b.getState() & 0x38) == 0) {
                    qc.bundleQuiesced(new Bundle[]{b});
                } else {
                    this.executor.execute(new QuiesceBundle(qc, b, this.quiesceHandler));
                }
            }
            catch (RejectedExecutionException re) {
                this.unhandledQuiesces.add(new QuiesceDelegatingCallback(qc, b));
            }
            if (!b.equals(this.context.getBundle())) continue;
            closeSelf = true;
        }
        if (closeSelf) {
            IOUtils.close((Closeable)this);
        }
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        try {
            for (DestroyCallback cbk : this.unhandledQuiesces) {
                cbk.callback();
            }
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executor.shutdownNow();
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.quiesceReg);
    }

    private static final class QuiesceBundle
    implements Runnable {
        private final DestroyCallback callback;
        private final Bundle bundleToQuiesce;
        private final QuiesceHandler quiesceHandler;

        public QuiesceBundle(QuiesceCallback callback, Bundle bundleToQuiesce, QuiesceHandler quiesceHandler) {
            this.callback = new QuiesceDelegatingCallback(callback, bundleToQuiesce);
            this.bundleToQuiesce = bundleToQuiesce;
            this.quiesceHandler = quiesceHandler;
        }

        @Override
        public void run() {
            this.quiesceHandler.quiesceBundle(this.bundleToQuiesce, this.callback);
        }
    }

    private static final class QuiesceDelegatingCallback
    implements DestroyCallback {
        private final QuiesceCallback callback;
        private final Bundle toQuiesce;

        public QuiesceDelegatingCallback(QuiesceCallback cbk, Bundle b) {
            this.callback = cbk;
            this.toQuiesce = b;
        }

        @Override
        public void callback() {
            this.callback.bundleQuiesced(new Bundle[]{this.toQuiesce});
        }
    }
}

