/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.impl.ManagedEMF;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceTracker
extends ServiceTracker<DataSource, ManagedEMF> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceTracker.class);
    private PersistenceProvider provider;
    private PersistenceUnit punit;
    static final String DS_PREFIX = "osgi:service/javax.sql.DataSource";

    public DataSourceTracker(BundleContext context, PersistenceProvider provider, PersistenceUnit punit) {
        super(context, DataSourceTracker.createFilter(context, punit), null);
        this.provider = provider;
        this.punit = punit;
    }

    static Filter createFilter(BundleContext context, PersistenceUnit punit) {
        String dsName = DataSourceTracker.getDsName(punit);
        if (dsName == null) {
            throw new IllegalArgumentException("No DataSource supplied in persistence.xml");
        }
        String subFilter = DataSourceTracker.getSubFilter(dsName);
        String filter = String.format("(&(objectClass=%s)%s)", DataSource.class.getName(), subFilter);
        LOGGER.info("Tracking DataSource for punit " + punit.getPersistenceUnitName() + " with filter " + filter);
        try {
            return context.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String getSubFilter(String dsName) {
        if (dsName.startsWith(DS_PREFIX)) {
            return dsName.length() > DS_PREFIX.length() + 1 ? dsName.substring(DS_PREFIX.length() + 1) : "(osgi.jndi.service.name=*)";
        }
        return "(osgi.jndi.service.name=" + dsName + ")";
    }

    private static String getDsName(PersistenceUnit punit) {
        return punit.getTransactionType() == PersistenceUnitTransactionType.JTA ? punit.getJtaDataSourceName() : punit.getNonJtaDataSourceName();
    }

    public ManagedEMF addingService(ServiceReference<DataSource> reference) {
        LOGGER.info("Found DataSource for " + this.punit.getPersistenceUnitName() + " " + DataSourceTracker.getDsName(this.punit));
        DataSource ds = (DataSource)this.context.getService(reference);
        if (this.punit.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            this.punit.setJtaDataSource(ds);
        } else {
            this.punit.setNonJtaDataSource(ds);
        }
        BundleContext containerContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        return new ManagedEMF(containerContext, this.punit.getBundle(), this.provider, this.punit);
    }

    public void removedService(ServiceReference<DataSource> reference, ManagedEMF managedEMF) {
        LOGGER.info("Lost DataSource for " + this.punit.getPersistenceUnitName() + " " + DataSourceTracker.getDsName(this.punit));
        managedEMF.close();
        super.removedService(reference, (Object)managedEMF);
    }
}

