/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.weaving.impl;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class DummyDataSource
implements DataSource {
    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        DummyHandler handler = new DummyHandler();
        ClassLoader classLoader = this.getClass().getClassLoader();
        return (Connection)Proxy.newProxyInstance(classLoader, new Class[]{Connection.class}, (InvocationHandler)handler);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    private final class DummyHandler
    implements InvocationHandler {
        private DummyHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> type = method.getReturnType();
            if (type == Integer.TYPE) {
                return new Integer(0);
            }
            if (type == Boolean.TYPE) {
                return new Boolean(false);
            }
            if (type == String.class) {
                return "";
            }
            return this.proxyClasses(classLoader, type);
        }

        private Object proxyClasses(ClassLoader classLoader, Class<?> type) {
            if (type == DatabaseMetaData.class) {
                return this.createProxy(classLoader, DatabaseMetaData.class);
            }
            if (type == ResultSet.class) {
                return this.createProxy(classLoader, ResultSet.class);
            }
            return null;
        }

        private Object createProxy(ClassLoader classLoader, Class<?> iface) {
            Class[] ifAr = new Class[]{iface};
            return Proxy.newProxyInstance(classLoader, ifAr, (InvocationHandler)this);
        }
    }
}

