/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.weaving.impl;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import javax.persistence.spi.ClassTransformer;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

class WrappingTransformer
implements ClassTransformer {
    private final ClassTransformer delegate;
    private final Collection<String> packageImportsToAdd = new HashSet<String>();

    public WrappingTransformer(ClassTransformer transformer) {
        this.delegate = transformer;
    }

    public WrappingTransformer(ClassTransformer delegate, ServiceReference<?> persistenceProvider) {
        WrappingTransformer.validate(delegate, persistenceProvider);
        this.delegate = delegate;
        Object packages = persistenceProvider.getProperty("org.apache.aries.jpa.container.weaving.packages");
        if (packages instanceof String[]) {
            for (String s : (String[])packages) {
                this.packageImportsToAdd.add(s);
            }
        } else {
            Bundle provider = persistenceProvider.getBundle();
            String suffix = ";bundle-symbolic-name=" + provider.getSymbolicName() + ";" + "bundle-version" + "=" + provider.getVersion();
            BundleRevision br = ((BundleWiring)provider.adapt(BundleWiring.class)).getRevision();
            for (BundleCapability bc : br.getDeclaredCapabilities("osgi.wiring.package")) {
                this.packageImportsToAdd.add(bc.getAttributes().get("osgi.wiring.package") + suffix);
            }
        }
    }

    private static void validate(ClassTransformer delegate, ServiceReference<?> persistenceProvider) {
        if (delegate == null) {
            throw new NullPointerException("Transformer delegate may not be null");
        }
        if (persistenceProvider == null) {
            throw new NullPointerException("PersistenceProvider may not be null");
        }
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        return this.delegate.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    public Collection<String> getPackagesToAdd() {
        return this.packageImportsToAdd;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof WrappingTransformer) {
            return this.delegate == ((WrappingTransformer)o).delegate;
        }
        return false;
    }

    public String toString() {
        return "Transformer: " + this.delegate.toString() + " Packages to add: " + this.packageImportsToAdd;
    }
}

