/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.context.transaction.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import org.apache.aries.jpa.container.context.impl.NLS;
import org.apache.aries.jpa.container.context.transaction.impl.DestroyCallback;
import org.apache.aries.jpa.container.context.transaction.impl.JTAPersistenceContextRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTAEntityManager
implements EntityManager {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container.context");
    private final EntityManagerFactory emf;
    private final Map<String, Object> props;
    private final JTAPersistenceContextRegistry reg;
    private final AtomicLong instanceCount;
    private final DestroyCallback callback;
    private EntityManager detachedManager = null;

    public JTAEntityManager(EntityManagerFactory factory, Map<String, Object> properties, JTAPersistenceContextRegistry registry, AtomicLong activeCount, DestroyCallback onDestroy) {
        this.emf = factory;
        this.props = properties;
        this.reg = registry;
        this.instanceCount = activeCount;
        this.callback = onDestroy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManager getPersistenceContext(boolean forceTransaction) {
        if (forceTransaction) {
            return this.reg.getCurrentPersistenceContext(this.emf, this.props, this.instanceCount, this.callback);
        }
        if (this.reg.isTransactionActive()) {
            return this.reg.getCurrentPersistenceContext(this.emf, this.props, this.instanceCount, this.callback);
        }
        if (!this.reg.jtaIntegrationAvailable() && _logger.isDebugEnabled()) {
            _logger.debug("No integration with JTA transactions is available. No transaction context is active.");
        }
        if (this.detachedManager == null) {
            EntityManager temp = this.emf.createEntityManager(this.props);
            JTAEntityManager jTAEntityManager = this;
            synchronized (jTAEntityManager) {
                if (this.detachedManager == null) {
                    this.detachedManager = temp;
                    temp = null;
                }
            }
            if (temp != null) {
                temp.close();
            }
        }
        return this.detachedManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalClose() {
        EntityManager temp = null;
        JTAEntityManager jTAEntityManager = this;
        synchronized (jTAEntityManager) {
            temp = this.detachedManager;
            this.detachedManager = null;
        }
        if (temp != null) {
            temp.close();
        }
    }

    public void clear() {
        this.getPersistenceContext(false).clear();
    }

    public void close() {
        throw new IllegalStateException(NLS.MESSAGES.getMessage("close.called.on.container.manged.em", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object arg0) {
        boolean bl;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                bl = em.contains(arg0);
                Object var5_4 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String arg0) {
        Query query;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                query = em.createNamedQuery(arg0);
                Object var5_4 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String arg0) {
        Query query;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                query = em.createNativeQuery(arg0);
                Object var5_4 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String arg0, Class arg1) {
        Query query;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                query = em.createNativeQuery(arg0, arg1);
                Object var6_5 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String arg0, String arg1) {
        Query query;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                query = em.createNativeQuery(arg0, arg1);
                Object var6_5 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String arg0) {
        Query query;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                query = em.createQuery(arg0);
                Object var5_4 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> arg0, Object arg1) {
        Object object;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                object = em.find(arg0, arg1);
                Object var6_5 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return (T)object;
    }

    public void flush() {
        this.getPersistenceContext(true).flush();
    }

    public Object getDelegate() {
        return this.getPersistenceContext(false).getDelegate();
    }

    public FlushModeType getFlushMode() {
        return this.getPersistenceContext(false).getFlushMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> arg0, Object arg1) {
        Object object;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                object = em.getReference(arg0, arg1);
                Object var6_5 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return (T)object;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException(NLS.MESSAGES.getMessage("getTransaction.called.on.container.managed.em", new Object[0]));
    }

    public boolean isOpen() {
        return true;
    }

    public void joinTransaction() {
    }

    public void lock(Object arg0, LockModeType arg1) {
        this.getPersistenceContext(true).lock(arg0, arg1);
    }

    public <T> T merge(T arg0) {
        return (T)this.getPersistenceContext(true).merge(arg0);
    }

    public void persist(Object arg0) {
        this.getPersistenceContext(true).persist(arg0);
    }

    public void refresh(Object arg0) {
        this.getPersistenceContext(true).refresh(arg0);
    }

    public void remove(Object arg0) {
        this.getPersistenceContext(true).remove(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFlushMode(FlushModeType arg0) {
        EntityManager em = this.getPersistenceContext(false);
        try {
            em.setFlushMode(arg0);
            Object var4_3 = null;
            if (em != this.detachedManager) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (em != this.detachedManager) throw throwable;
            em.clear();
            throw throwable;
        }
        em.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createNamedQuery(String arg0, Class<T> arg1) {
        TypedQuery typedQuery;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                typedQuery = em.createNamedQuery(arg0, arg1);
                Object var6_5 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return typedQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> arg0) {
        TypedQuery typedQuery;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                typedQuery = em.createQuery(arg0);
                Object var5_4 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return typedQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(String arg0, Class<T> arg1) {
        TypedQuery typedQuery;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                typedQuery = em.createQuery(arg0, arg1);
                Object var6_5 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return typedQuery;
    }

    public void detach(Object arg0) {
        EntityManager em = this.getPersistenceContext(false);
        if (em != this.detachedManager) {
            em.detach(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> arg0, Object arg1, Map<String, Object> arg2) {
        Object object;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                object = em.find(arg0, arg1, arg2);
                Object var7_6 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2) {
        Object object;
        block2: {
            EntityManager em = this.getPersistenceContext(arg2 != LockModeType.NONE);
            try {
                object = em.find(arg0, arg1, arg2);
                Object var7_6 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2, Map<String, Object> arg3) {
        Object object;
        block2: {
            EntityManager em = this.getPersistenceContext(arg2 != LockModeType.NONE);
            try {
                object = em.find(arg0, arg1, arg2, arg3);
                Object var8_7 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var8_8 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return (T)object;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getPersistenceContext(false).getCriteriaBuilder();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public LockModeType getLockMode(Object arg0) {
        return this.getPersistenceContext(true).getLockMode(arg0);
    }

    public Metamodel getMetamodel() {
        return this.getPersistenceContext(false).getMetamodel();
    }

    public Map<String, Object> getProperties() {
        return this.getPersistenceContext(false).getProperties();
    }

    public void lock(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
        this.getPersistenceContext(true).lock(arg0, arg1, arg2);
    }

    public void refresh(Object arg0, Map<String, Object> arg1) {
        this.getPersistenceContext(true).refresh(arg0, arg1);
    }

    public void refresh(Object arg0, LockModeType arg1) {
        this.getPersistenceContext(true).refresh(arg0, arg1);
    }

    public void refresh(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
        this.getPersistenceContext(true).refresh(arg0, arg1, arg2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String arg0, Object arg1) {
        EntityManager em = this.getPersistenceContext(false);
        try {
            em.setProperty(arg0, arg1);
            Object var5_4 = null;
            if (em != this.detachedManager) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (em != this.detachedManager) throw throwable;
            em.clear();
            throw throwable;
        }
        em.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unwrap(Class<T> arg0) {
        Object object;
        block2: {
            EntityManager em = this.getPersistenceContext(false);
            try {
                object = em.unwrap(arg0);
                Object var5_4 = null;
                if (em != this.detachedManager) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (em != this.detachedManager) break block3;
                    em.clear();
                }
                throw throwable;
            }
            em.clear();
        }
        return (T)object;
    }
}

