/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.support.osgi.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.transaction.TransactionManager;
import org.apache.aries.jpa.supplier.EmSupplier;
import org.apache.aries.jpa.support.impl.XAJpaTemplate;
import org.apache.aries.jpa.template.JpaTemplate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMTracker
extends ServiceTracker<TransactionManager, ServiceRegistration> {
    private static final Logger LOG = LoggerFactory.getLogger(TMTracker.class);
    static final String TRANSACTION_TYPE = "transaction.type";
    private final EmSupplier emSupplier;
    private final String unitName;
    private Coordinator coordinator;

    public TMTracker(BundleContext context, EmSupplier emSupplier, String unitName, Coordinator coordinator) {
        super(context, TransactionManager.class, null);
        this.emSupplier = emSupplier;
        this.unitName = unitName;
        this.coordinator = coordinator;
    }

    public ServiceRegistration addingService(ServiceReference<TransactionManager> ref) {
        TransactionManager tm = (TransactionManager)this.context.getService(ref);
        XAJpaTemplate txManager = new XAJpaTemplate(this.emSupplier, tm, this.coordinator);
        return this.context.registerService(JpaTemplate.class, (Object)txManager, TMTracker.xaTxManProps(this.unitName));
    }

    private static Dictionary<String, String> xaTxManProps(String unitName) {
        Hashtable<String, String> txmanProperties = new Hashtable<String, String>();
        ((Dictionary)txmanProperties).put("osgi.unit.name", unitName);
        ((Dictionary)txmanProperties).put(TRANSACTION_TYPE, "JTA");
        return txmanProperties;
    }

    public void removedService(ServiceReference<TransactionManager> reference, ServiceRegistration reg) {
        try {
            reg.unregister();
            this.context.ungetService(reference);
        }
        catch (Exception e) {
            LOG.debug("Exception during unregister", (Throwable)e);
        }
    }
}

