/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.support.xa.impl;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.aries.jpa.support.xa.impl.TransactionToken;
import org.apache.aries.jpa.template.TransactionType;

public enum TransactionAttribute {
    MANDATORY{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 6) {
                throw new IllegalStateException("This method has transaction attr MANADATORY but no active transaction was found.");
            }
            return new TransactionToken(man.getTransaction(), null, MANDATORY);
        }
    }
    ,
    NEVER{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                throw new IllegalStateException("This method has transactui attr NEVER but a transaction is active.");
            }
            return new TransactionToken(null, null, NEVER);
        }
    }
    ,
    NOTSUPPORTED{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                return new TransactionToken(null, man.suspend(), this);
            }
            return new TransactionToken(null, null, NOTSUPPORTED);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException {
            Transaction tran = tranToken.getSuspendedTransaction();
            if (tran != null) {
                man.resume(tran);
            }
        }
    }
    ,
    REQUIRED{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException {
            if (man.getStatus() == 6) {
                man.begin();
                return new TransactionToken(man.getTransaction(), null, REQUIRED, true);
            }
            return new TransactionToken(man.getTransaction(), null, REQUIRED);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
        }
    }
    ,
    REQUIRESNEW{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException {
            TransactionToken tranToken = man.getStatus() == 0 ? new TransactionToken(null, man.suspend(), REQUIRESNEW) : new TransactionToken(null, null, REQUIRESNEW);
            try {
                man.begin();
            }
            catch (SystemException e) {
                man.resume(tranToken.getSuspendedTransaction());
                throw e;
            }
            catch (NotSupportedException e) {
                man.resume(tranToken.getSuspendedTransaction());
                throw e;
            }
            tranToken.setActiveTransaction(man.getTransaction());
            tranToken.setCompletionAllowed(true);
            return tranToken;
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            Transaction tran;
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
            if ((tran = tranToken.getSuspendedTransaction()) != null) {
                man.resume(tran);
            }
        }
    }
    ,
    SUPPORTS{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException {
            if (man.getStatus() == 0) {
                return new TransactionToken(man.getTransaction(), null, SUPPORTS);
            }
            return new TransactionToken(null, null, SUPPORTS);
        }
    };


    public static TransactionAttribute fromValue(String value) {
        return TransactionAttribute.valueOf(value.toUpperCase());
    }

    public static TransactionAttribute fromType(TransactionType type) {
        return TransactionAttribute.valueOf(type.name().toUpperCase());
    }

    public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException {
        return null;
    }

    public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
    }
}

