/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.TypeAttribute;
import org.apache.aries.subsystem.core.archive.VersionAttribute;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.OsgiIdentityRequirement;
import org.osgi.framework.Version;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class AriesSubsystemParentsHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String NAME = "AriesSubsystem-Parents";

    private static StringBuilder appendSubsystem(BasicSubsystem subsystem, StringBuilder builder, boolean referenceCount) {
        String symbolicName = subsystem.getSymbolicName();
        Version version = subsystem.getVersion();
        String type = subsystem.getType();
        builder.append(symbolicName).append(';').append("version").append('=').append(version.toString()).append(';').append("type").append('=').append(type).append(';').append("resourceId").append('=').append(subsystem.getSubsystemId());
        return builder;
    }

    public AriesSubsystemParentsHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    public AriesSubsystemParentsHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    public boolean contains(BasicSubsystem subsystem) {
        return this.getClause(subsystem) != null;
    }

    public Clause getClause(BasicSubsystem subsystem) {
        String symbolicName = subsystem.getSymbolicName();
        Version version = subsystem.getVersion();
        String type = subsystem.getType();
        for (Clause clause : this.clauses) {
            if (!symbolicName.equals(clause.getPath()) || !clause.getVersion().equals((Object)version) || !type.equals(clause.getType())) continue;
            return clause;
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<Requirement> toRequirements(Resource resource) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public static class Clause
    extends AbstractClause {
        public static final String ATTRIBUTE_VERSION = "version";
        public static final String ATTRIBUTE_RESOURCEID = "resourceId";
        public static final String ATTRIBUTE_TYPE = "type";

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.SYMBOLIC_NAME, false), Clause.parseParameters(clause, true), Clause.generateDefaultParameters(TypeAttribute.newInstance("osgi.subsystem.application"), VersionRangeAttribute.DEFAULT_VERSION));
        }

        public Clause(BasicSubsystem subsystem, boolean referenceCount) {
            this(AriesSubsystemParentsHeader.appendSubsystem(subsystem, new StringBuilder(), referenceCount).toString());
        }

        public boolean contains(BasicSubsystem subsystem) {
            return this.getSymbolicName().equals(subsystem.getSymbolicName()) && this.getVersion().equals((Object)subsystem.getVersion()) && this.getType().equals(subsystem.getType());
        }

        public long getId() {
            Attribute attribute = this.getAttribute(ATTRIBUTE_RESOURCEID);
            if (attribute == null) {
                return -1L;
            }
            return Long.valueOf(String.valueOf(attribute.getValue()));
        }

        public String getSymbolicName() {
            return this.path;
        }

        public String getType() {
            return ((TypeAttribute)this.getAttribute(ATTRIBUTE_TYPE)).getType();
        }

        public Version getVersion() {
            return ((VersionAttribute)this.getAttribute(ATTRIBUTE_VERSION)).getVersion();
        }

        public OsgiIdentityRequirement toRequirement(Resource resource) {
            return new OsgiIdentityRequirement(this.getSymbolicName(), this.getVersion(), this.getType(), false);
        }
    }
}

