/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import org.apache.aries.subsystem.core.archive.CardinalityDirective;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.EffectiveDirective;
import org.apache.aries.subsystem.core.archive.FilterDirective;
import org.apache.aries.subsystem.core.archive.GenericDirective;
import org.apache.aries.subsystem.core.archive.ProvisionPolicyDirective;
import org.apache.aries.subsystem.core.archive.ReferenceDirective;
import org.apache.aries.subsystem.core.archive.ResolutionDirective;
import org.apache.aries.subsystem.core.archive.StartOrderDirective;
import org.apache.aries.subsystem.core.archive.VisibilityDirective;

public class DirectiveFactory {
    public static Directive createDirective(String name, String value) {
        if ("resolution".equals(name)) {
            return ResolutionDirective.getInstance(value);
        }
        if ("start-order".equals(name)) {
            return new StartOrderDirective(value);
        }
        if ("filter".equals(name)) {
            return new FilterDirective(value);
        }
        if ("effective".equals(name)) {
            return EffectiveDirective.getInstance(value);
        }
        if ("visibility".equals(name)) {
            return VisibilityDirective.getInstance(value);
        }
        if ("provision-policy".equals(name)) {
            return ProvisionPolicyDirective.getInstance(value);
        }
        if ("reference".equals(name)) {
            return ReferenceDirective.getInstance(value);
        }
        if ("cardinality".equals(name)) {
            return CardinalityDirective.getInstance(value);
        }
        return new GenericDirective(name, value);
    }
}

