/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.internal.AbstractCapability;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class BasicCapability
extends AbstractCapability {
    private final Map<String, Object> attributes;
    private final Map<String, String> directives;
    private final Resource resource;
    private final String namespace;

    public BasicCapability(Capability capability, Resource resource) {
        if (resource == null) {
            throw new NullPointerException();
        }
        this.attributes = capability.getAttributes();
        this.directives = capability.getDirectives();
        this.resource = resource;
        this.namespace = capability.getNamespace();
    }

    public BasicCapability(String namespace, Map<String, Object> attributes, Map<String, String> directives, Resource resource) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        this.namespace = namespace;
        this.attributes = attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Object>(attributes));
        this.directives = directives == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(directives));
        if (resource == null) {
            throw new NullPointerException();
        }
        this.resource = resource;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Resource getResource() {
        return this.resource;
    }

    public static class Builder {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final Map<String, String> directives = new HashMap<String, String>();
        private Resource resource;
        private String namespace;

        public Builder attribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder attributes(Map<String, Object> values) {
            this.attributes.putAll(values);
            return this;
        }

        public BasicCapability build() {
            return new BasicCapability(this.namespace, this.attributes, this.directives, this.resource);
        }

        public Builder directive(String key, String value) {
            this.directives.put(key, value);
            return this;
        }

        public Builder directives(Map<String, String> values) {
            this.directives.putAll(values);
            return this;
        }

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder resource(Resource value) {
            this.resource = value;
            return this;
        }
    }
}

