/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.aries.subsystem.core.internal.BasicCapability;
import org.apache.aries.subsystem.core.internal.BasicRequirement;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleRevisionResource;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.apache.aries.subsystem.core.internal.ThreadLocalSubsystem;
import org.apache.aries.util.io.IOUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.subsystem.SubsystemException;

public class BundleResourceInstaller
extends ResourceInstaller {
    public BundleResourceInstaller(Coordination coordination, Resource resource, BasicSubsystem subsystem) {
        super(coordination, resource, subsystem);
    }

    @Override
    public Resource install() {
        BundleRevision revision;
        if (this.resource instanceof BundleRevision) {
            revision = (BundleRevision)this.resource;
        } else if (this.resource instanceof BundleRevisionResource) {
            revision = ((BundleRevisionResource)this.resource).getRevision();
        } else {
            try {
                revision = this.installBundle();
            }
            catch (Exception e) {
                throw new SubsystemException((Throwable)e);
            }
        }
        this.addReference((Resource)revision);
        this.addConstituent((Resource)new BundleConstituent(this.resource, revision));
        return revision;
    }

    private BundleRevision installBundle() throws Exception {
        Bundle bundle;
        Method getContent = this.resource.getClass().getMethod("getContent", new Class[0]);
        getContent.setAccessible(true);
        InputStream is = (InputStream)getContent.invoke((Object)this.resource, new Object[0]);
        ThreadLocalSubsystem.set(this.provisionTo);
        try {
            bundle = this.provisionTo.getRegion().installBundleAtLocation(this.getLocation(), is);
        }
        catch (BundleException e) {
            throw new SubsystemException((Throwable)e);
        }
        finally {
            ThreadLocalSubsystem.remove();
            IOUtils.close((Closeable)is);
        }
        this.coordination.addParticipant(new Participant(){

            public void ended(Coordination coordination) throws Exception {
            }

            public void failed(Coordination coordination) throws Exception {
                bundle.uninstall();
            }
        });
        ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(1);
        return (BundleRevision)bundle.adapt(BundleRevision.class);
    }

    static class BundleConstituent
    implements BundleRevision {
        private final Resource resource;
        private final BundleRevision revision;

        public BundleConstituent(Resource resource, BundleRevision revision) {
            if (resource instanceof BundleRevision) {
                try {
                    this.resource = new BundleRevisionResource((BundleRevision)resource);
                }
                catch (SubsystemException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SubsystemException((Throwable)e);
                }
            } else {
                this.resource = resource;
            }
            this.revision = revision;
        }

        public List<Capability> getCapabilities(String namespace) {
            ArrayList<BasicCapability> result = new ArrayList<BasicCapability>(this.revision.getCapabilities(namespace));
            if (this.resource != null && (namespace == null || "osgi.service".equals(namespace))) {
                for (Capability capability : this.resource.getCapabilities("osgi.service")) {
                    result.add(new BasicCapability.Builder().namespace(capability.getNamespace()).attributes(capability.getAttributes()).directives(capability.getDirectives()).resource((Resource)this.revision).build());
                }
            }
            return Collections.unmodifiableList(result);
        }

        public List<Requirement> getRequirements(String namespace) {
            ArrayList<BasicRequirement> result = new ArrayList<BasicRequirement>(this.revision.getRequirements(namespace));
            if (this.resource != null && (namespace == null || "osgi.service".equals(namespace))) {
                for (Requirement requiremnet : this.resource.getRequirements("osgi.service")) {
                    result.add(new BasicRequirement.Builder().namespace(requiremnet.getNamespace()).attributes(requiremnet.getAttributes()).directives(requiremnet.getDirectives()).resource((Resource)this.revision).build());
                }
            }
            return Collections.unmodifiableList(result);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BundleConstituent)) {
                return false;
            }
            BundleConstituent that = (BundleConstituent)o;
            return this.revision.equals(that.revision);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.revision.hashCode();
            return result;
        }

        public Bundle getBundle() {
            return this.revision.getBundle();
        }

        public Resource getResource() {
            return this.resource;
        }

        public BundleRevision getRevision() {
            return this.revision;
        }

        public String getSymbolicName() {
            return this.revision.getSymbolicName();
        }

        public Version getVersion() {
            return this.revision.getVersion();
        }

        public List<BundleCapability> getDeclaredCapabilities(String namespace) {
            return this.revision.getDeclaredCapabilities(namespace);
        }

        public List<BundleRequirement> getDeclaredRequirements(String namespace) {
            return this.revision.getDeclaredRequirements(namespace);
        }

        public int getTypes() {
            return this.revision.getTypes();
        }

        public BundleWiring getWiring() {
            return this.revision.getWiring();
        }

        public String toString() {
            return this.revision.toString();
        }
    }
}

