/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.apache.aries.subsystem.core.internal.SecurityManager;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.subsystem.core.internal.TargetRegion;
import org.apache.aries.subsystem.core.internal.Utils;
import org.apache.aries.util.filesystem.ICloseableDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallAction
implements PrivilegedAction<BasicSubsystem> {
    private final IDirectory content;
    private final AccessControlContext context;
    private final InputStream deploymentManifest;
    private final String location;
    private final BasicSubsystem parent;
    private static final Logger logger = LoggerFactory.getLogger(InstallAction.class);

    public InstallAction(String location, IDirectory content, BasicSubsystem parent, AccessControlContext context, InputStream deploymentManifest) {
        this.location = location;
        this.content = content;
        this.parent = parent;
        this.context = context;
        this.deploymentManifest = deploymentManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BasicSubsystem run() {
        Coordination coordination = Utils.createCoordination(this.parent);
        BasicSubsystem result = null;
        try {
            TargetRegion region = new TargetRegion(this.parent);
            SubsystemResource ssr = new SubsystemResource(this.location, this.content, this.parent);
            result = Activator.getInstance().getSubsystems().getSubsystemByLocation(this.location);
            if (result != null) {
                this.checkLifecyclePermission(result);
                if (!region.contains((Subsystem)result)) {
                    throw new SubsystemException("Location already exists but existing subsystem is not part of target region: " + this.location);
                }
                if (!result.getSymbolicName().equals(ssr.getSubsystemManifest().getSubsystemSymbolicNameHeader().getSymbolicName())) throw new SubsystemException("Location already exists but symbolic name, version, and type are not the same: " + this.location);
                if (!result.getVersion().equals((Object)ssr.getSubsystemManifest().getSubsystemVersionHeader().getVersion())) throw new SubsystemException("Location already exists but symbolic name, version, and type are not the same: " + this.location);
                if (!result.getType().equals(ssr.getSubsystemManifest().getSubsystemTypeHeader().getType())) {
                    throw new SubsystemException("Location already exists but symbolic name, version, and type are not the same: " + this.location);
                }
                BasicSubsystem basicSubsystem = (BasicSubsystem)ResourceInstaller.newInstance(coordination, result, this.parent).install();
                return basicSubsystem;
            }
            result = (BasicSubsystem)region.find(ssr.getSubsystemManifest().getSubsystemSymbolicNameHeader().getSymbolicName(), ssr.getSubsystemManifest().getSubsystemVersionHeader().getVersion());
            if (result != null) {
                this.checkLifecyclePermission(result);
                if (!result.getType().equals(ssr.getSubsystemManifest().getSubsystemTypeHeader().getType())) {
                    throw new SubsystemException("Subsystem already exists in target region but has a different type: " + this.location);
                }
                BasicSubsystem basicSubsystem = (BasicSubsystem)ResourceInstaller.newInstance(coordination, result, this.parent).install();
                return basicSubsystem;
            }
            result = new BasicSubsystem(ssr, this.deploymentManifest);
            this.checkLifecyclePermission(result);
            BasicSubsystem basicSubsystem = (BasicSubsystem)ResourceInstaller.newInstance(coordination, result, this.parent).install();
            return basicSubsystem;
        }
        catch (Throwable t) {
            coordination.fail(t);
            return result;
        }
        finally {
            try {
                coordination.end();
            }
            catch (CoordinationException e) {
                Throwable t = e.getCause();
                if (t instanceof SubsystemException) {
                    throw (SubsystemException)t;
                }
                if (!(t instanceof SecurityException)) throw new SubsystemException(t);
                throw (SecurityException)t;
            }
            finally {
                this.closeContentIfIClosable();
            }
        }
    }

    private void closeContentIfIClosable() {
        if (this.content instanceof ICloseableDirectory) {
            try {
                ((ICloseableDirectory)this.content).close();
            }
            catch (IOException ioex) {
                logger.info("Exception calling close for content {}. Exception {}", (Object)this.content, (Object)ioex);
            }
        }
    }

    private void checkLifecyclePermission(final BasicSubsystem subsystem) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityManager.checkLifecyclePermission((Subsystem)subsystem);
                return null;
            }
        }, this.context);
    }
}

