/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.PreferredProviderHeader;
import org.apache.aries.subsystem.core.archive.PreferredProviderRequirement;
import org.apache.aries.subsystem.core.capabilityset.CapabilitySetRepository;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.RepositoryServiceRepository;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.subsystem.core.repository.Repository;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class PreferredProviderRepository
implements Repository {
    private final CapabilitySetRepository repository;
    private final SubsystemResource resource;

    public PreferredProviderRepository(SubsystemResource resource) {
        this.resource = resource;
        this.repository = new CapabilitySetRepository();
        PreferredProviderHeader header = resource.getSubsystemManifest().getPreferredProviderHeader();
        if (header != null) {
            List<PreferredProviderRequirement> requirements = header.toRequirements(resource);
            for (PreferredProviderRequirement requirement : requirements) {
                if (this.addProviders(requirement, Activator.getInstance().getSystemRepository(), true) || this.addProviders(requirement, resource.getLocalRepository(), false)) continue;
                this.addProviders(requirement, new RepositoryServiceRepository(), false);
            }
        }
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        return this.repository.findProviders(requirements);
    }

    private boolean addProviders(Requirement requirement, Repository repository, boolean checkValid) {
        boolean result = false;
        Map<Requirement, Collection<Capability>> map = repository.findProviders(Collections.singleton(requirement));
        Collection<Capability> capabilities = map.get(requirement);
        for (Capability capability : capabilities) {
            if (checkValid && !this.isValid(capability)) continue;
            this.repository.addResource(capability.getResource());
            result = true;
        }
        return result;
    }

    private boolean isValid(Capability capability) {
        for (BasicSubsystem parent : this.resource.getParents()) {
            Object provider = capability.getResource();
            if (provider instanceof BundleRevision) {
                provider = new BundleResourceInstaller.BundleConstituent(null, (BundleRevision)provider);
            }
            if (!parent.getConstituents().contains(provider)) continue;
            return true;
        }
        return false;
    }
}

