/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.apache.aries.subsystem.core.internal.ResourceUninstaller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;

public class RegionContextBundleHelper {
    public static final String SYMBOLICNAME_PREFIX = "org.osgi.service.subsystem.region.context.";
    public static final Version VERSION = Version.parseVersion((String)"1.0.0");

    public static void installRegionContextBundle(BasicSubsystem subsystem, Coordination coordination) throws Exception {
        String symbolicName = SYMBOLICNAME_PREFIX + subsystem.getSubsystemId();
        String location = subsystem.getLocation() + '/' + subsystem.getSubsystemId();
        Bundle b = subsystem.getRegion().getBundle(symbolicName, VERSION);
        if (b == null) {
            b = subsystem.getRegion().installBundleAtLocation(location, RegionContextBundleHelper.createRegionContextBundle(symbolicName));
            ((BundleStartLevel)b.adapt(BundleStartLevel.class)).setStartLevel(1);
        }
        ResourceInstaller.newInstance(coordination, (Resource)b.adapt(BundleRevision.class), subsystem).install();
        b.start();
        subsystem.setRegionContextBundle(b);
    }

    public static void uninstallRegionContextBundle(BasicSubsystem subsystem) {
        String symbolicName = SYMBOLICNAME_PREFIX + subsystem.getSubsystemId();
        Bundle bundle = subsystem.getRegion().getBundle(symbolicName, VERSION);
        if (bundle == null) {
            return;
        }
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        try {
            bundle.uninstall();
        }
        catch (BundleException e) {
            // empty catch block
        }
        ResourceUninstaller.newInstance((Resource)revision, subsystem).uninstall();
        subsystem.setRegionContextBundle(null);
    }

    private static Manifest createManifest(String symbolicName) {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        manifest.getMainAttributes().putValue("Bundle-SymbolicName", symbolicName);
        manifest.getMainAttributes().putValue("Bundle-Version", VERSION.toString());
        return manifest;
    }

    private static InputStream createRegionContextBundle(String symbolicName) throws IOException {
        Manifest manifest = RegionContextBundleHelper.createManifest(symbolicName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jos = new JarOutputStream((OutputStream)baos, manifest);
        jos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

