/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.BundleRevisionResource;
import org.apache.aries.subsystem.core.internal.ContentRepository;
import org.apache.aries.subsystem.core.internal.DependencyCalculator;
import org.apache.aries.subsystem.core.internal.PreferredProviderRepository;
import org.apache.aries.subsystem.core.internal.RepositoryServiceRepository;
import org.apache.aries.subsystem.core.internal.SharingPolicyValidator;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.subsystem.core.internal.Utils;
import org.apache.aries.subsystem.core.repository.Repository;
import org.eclipse.equinox.region.Region;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.subsystem.SubsystemException;

public class ResolveContext
extends org.osgi.service.resolver.ResolveContext {
    private final Repository contentRepository;
    private final Repository localRepository;
    private final Repository preferredProviderRepository;
    private final Repository repositoryServiceRepository;
    private final SubsystemResource resource;
    private final Repository systemRepository;
    private final Map<Resource, Wiring> wirings = this.computeWirings();

    public ResolveContext(SubsystemResource resource) {
        this.resource = resource;
        this.contentRepository = new ContentRepository(resource.getInstallableContent(), resource.getSharedContent());
        this.localRepository = resource.getLocalRepository();
        this.preferredProviderRepository = new PreferredProviderRepository(resource);
        this.repositoryServiceRepository = new RepositoryServiceRepository();
        this.systemRepository = Activator.getInstance().getSystemRepository();
    }

    public List<Capability> findProviders(Requirement requirement) {
        ArrayList<Capability> result = new ArrayList<Capability>();
        try {
            String resolution;
            if ("osgi.ee".equals(requirement.getNamespace()) || "osgi.native".equals(requirement.getNamespace())) {
                this.addDependenciesFromSystemRepository(requirement, result);
            } else {
                this.addDependenciesFromContentRepository(requirement, result);
                this.addDependenciesFromPreferredProviderRepository(requirement, result);
                this.addDependenciesFromSystemRepository(requirement, result);
                this.addDependenciesFromLocalRepository(requirement, result);
                if (result.isEmpty()) {
                    this.addDependenciesFromRepositoryServiceRepositories(requirement, result);
                }
            }
            if (result.isEmpty() && "optional".equals(resolution = (String)requirement.getDirectives().get("resolution"))) {
                result.add(new DependencyCalculator.MissingCapability(requirement));
            }
        }
        catch (Throwable t) {
            if (t instanceof SubsystemException) {
                throw (SubsystemException)t;
            }
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            throw new SubsystemException(t);
        }
        result.trimToSize();
        return result;
    }

    public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
        int sz = capabilities.size();
        capabilities.add(sz, (Capability)hostedCapability);
        return sz;
    }

    public boolean isEffective(Requirement requirement) {
        return true;
    }

    public Collection<Resource> getMandatoryResources() {
        return this.resource.getMandatoryResources();
    }

    public Collection<Resource> getOptionalResources() {
        return this.resource.getOptionalResources();
    }

    public Map<Resource, Wiring> getWirings() {
        return this.wirings;
    }

    private boolean addDependencies(Repository repository, Requirement requirement, List<Capability> capabilities, boolean validate) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (repository == null) {
            return false;
        }
        Map<Requirement, Collection<Capability>> m = repository.findProviders(Collections.singleton(requirement));
        if (m.containsKey(requirement)) {
            Collection<Capability> cc = m.get(requirement);
            this.addValidCapabilities(cc, capabilities, requirement, validate);
        }
        return !capabilities.isEmpty();
    }

    private boolean addDependenciesFromContentRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.contentRepository, requirement, capabilities, false);
    }

    private boolean addDependenciesFromLocalRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.localRepository, requirement, capabilities, true);
    }

    private boolean addDependenciesFromPreferredProviderRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.preferredProviderRepository, requirement, capabilities, true);
    }

    private boolean addDependenciesFromRepositoryServiceRepositories(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.repositoryServiceRepository, requirement, capabilities, true);
    }

    private boolean addDependenciesFromSystemRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.systemRepository, requirement, capabilities, true);
    }

    private void addValidCapabilities(Collection<Capability> from, Collection<Capability> to, Requirement requirement, boolean validate) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        for (Capability c : from) {
            if (validate && !this.isValid(c, requirement)) continue;
            to.add(c);
        }
    }

    private void addWiring(Resource resource, Map<Resource, Wiring> wirings) {
        if (resource instanceof BundleResourceInstaller.BundleConstituent) {
            BundleResourceInstaller.BundleConstituent bc = (BundleResourceInstaller.BundleConstituent)resource;
            wirings.put((Resource)bc.getBundle().adapt(BundleRevision.class), (Wiring)bc.getWiring());
        } else if (resource instanceof BundleRevision) {
            BundleRevision br = (BundleRevision)resource;
            wirings.put((Resource)br, (Wiring)br.getWiring());
        }
    }

    private Map<Resource, Wiring> computeWirings() {
        HashMap<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();
        for (BasicSubsystem subsystem : Activator.getInstance().getSubsystems().getSubsystems()) {
            for (Resource constituent : subsystem.getConstituents()) {
                this.addWiring(constituent, wirings);
            }
        }
        return Collections.unmodifiableMap(wirings);
    }

    private Region findRegionForCapabilityValidation(Resource resource) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (this.isInstallable(resource)) {
            if (this.isContent(resource) || this.resource.getSubsystemManifest().getSubsystemTypeHeader().getProvisionPolicyDirective().isAcceptDependencies()) {
                if (this.resource.isComposite()) {
                    return this.resource.getRegion();
                }
                return this.resource.getParents().iterator().next().getRegion();
            }
            if (this.resource.isComposite() && this.resource.getSubsystemManifest().getSubsystemTypeHeader().getProvisionPolicyDirective().isAcceptDependencies()) {
                return this.resource.getRegion();
            }
            return Utils.findFirstSubsystemAcceptingDependenciesStartingFrom(this.resource.getParents().iterator().next()).getRegion();
        }
        if (Utils.isBundle(resource)) {
            BundleRevision revision = resource instanceof BundleRevision ? (BundleRevision)resource : ((BundleRevisionResource)resource).getRevision();
            return Activator.getInstance().getRegionDigraph().getRegion(revision.getBundle());
        }
        return Activator.getInstance().getSubsystems().getSubsystemsReferencing(resource).iterator().next().getRegion();
    }

    private boolean isContent(Resource resource) {
        return this.resource.isContent(resource);
    }

    private boolean isInstallable(Resource resource) {
        return !this.isShared(resource);
    }

    private boolean isShared(Resource resource) {
        return Utils.isSharedResource(resource);
    }

    private boolean isValid(Capability capability, Requirement requirement) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if ("osgi.identity".equals(capability.getNamespace())) {
            return true;
        }
        Region from = this.findRegionForCapabilityValidation(capability.getResource());
        Region to = this.findRegionForCapabilityValidation(requirement.getResource());
        return new SharingPolicyValidator(from, to).isValid(capability);
    }
}

