/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import org.apache.aries.subsystem.ContentHandler;
import org.apache.aries.subsystem.core.archive.DeployedContentHeader;
import org.apache.aries.subsystem.core.archive.DeploymentManifest;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.CustomResourceInstaller;
import org.apache.aries.subsystem.core.internal.CustomResources;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.SubsystemResourceInstaller;
import org.apache.aries.subsystem.core.internal.Utils;
import org.osgi.framework.ServiceReference;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.subsystem.SubsystemException;

public abstract class ResourceInstaller {
    protected final Coordination coordination;
    protected final BasicSubsystem provisionTo;
    protected final Resource resource;
    protected final BasicSubsystem subsystem;

    public static ResourceInstaller newInstance(Coordination coordination, Resource resource, BasicSubsystem subsystem) {
        String type = ResourceHelper.getTypeAttribute(resource);
        if ("osgi.subsystem.application".equals(type) || "osgi.subsystem.composite".equals(type) || "osgi.subsystem.feature".equals(type)) {
            return new SubsystemResourceInstaller(coordination, resource, subsystem);
        }
        if ("osgi.bundle".equals(type) || "osgi.fragment".equals(type)) {
            return new BundleResourceInstaller(coordination, resource, subsystem);
        }
        if ("org.apache.aries.subsystem.resource.synthesized".equals(type)) {
            return new ResourceInstaller(coordination, resource, subsystem){

                @Override
                public Resource install() throws Exception {
                    return this.resource;
                }
            };
        }
        ServiceReference<ContentHandler> handlerRef = CustomResources.getCustomContentHandler(subsystem, type);
        if (handlerRef != null) {
            return new CustomResourceInstaller(coordination, resource, type, subsystem, handlerRef);
        }
        throw new SubsystemException("No installer exists for resource type: " + type);
    }

    public ResourceInstaller(Coordination coordination, Resource resource, BasicSubsystem subsystem) {
        this.coordination = coordination;
        this.resource = resource;
        this.subsystem = subsystem;
        this.provisionTo = this.isDependency() ? (Utils.isInstallableResource(resource) ? Utils.findFirstSubsystemAcceptingDependenciesStartingFrom(subsystem) : null) : subsystem;
    }

    public abstract Resource install() throws Exception;

    protected void addConstituent(final Resource resource) {
        if (this.provisionTo == null || resource.equals((Object)this.provisionTo)) {
            return;
        }
        Activator.getInstance().getSubsystems().addConstituent(this.provisionTo, resource, this.isReferencedProvisionTo());
        this.coordination.addParticipant(new Participant(){

            public void ended(Coordination arg0) throws Exception {
            }

            public void failed(Coordination arg0) throws Exception {
                Activator.getInstance().getSubsystems().removeConstituent(ResourceInstaller.this.provisionTo, resource);
            }
        });
    }

    protected void addReference(final Resource resource) {
        if (resource.equals((Object)this.subsystem)) {
            return;
        }
        if (this.isReferencedSubsystem()) {
            Activator.getInstance().getSubsystems().addReference(this.subsystem, resource);
            this.coordination.addParticipant(new Participant(){

                public void ended(Coordination arg0) throws Exception {
                }

                public void failed(Coordination arg0) throws Exception {
                    Activator.getInstance().getSubsystems().removeReference(ResourceInstaller.this.subsystem, resource);
                }
            });
        }
    }

    protected String getLocation() {
        return this.provisionTo.getLocation() + "!/" + ResourceHelper.getLocation(this.resource);
    }

    protected boolean isContent() {
        return Utils.isContent(this.subsystem, this.resource);
    }

    protected boolean isDependency() {
        return Utils.isDependency(this.subsystem, this.resource);
    }

    protected boolean isReferencedProvisionTo() {
        DeployedContentHeader header;
        DeploymentManifest manifest = this.subsystem.getDeploymentManifest();
        if (manifest != null && (header = manifest.getDeployedContentHeader()) != null && header.contains(this.resource)) {
            return this.subsystem.isReferenced(this.resource);
        }
        if (this.subsystem.equals(this.provisionTo)) {
            return this.isReferencedSubsystem();
        }
        return false;
    }

    protected boolean isReferencedSubsystem() {
        DeployedContentHeader header;
        DeploymentManifest manifest = this.subsystem.getDeploymentManifest();
        if (manifest != null && (header = manifest.getDeployedContentHeader()) != null && header.contains(this.resource)) {
            return this.subsystem.isReferenced(this.resource);
        }
        return true;
    }
}

