/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.apache.aries.subsystem.ContentHandler;
import org.apache.aries.subsystem.core.archive.ExportPackageCapability;
import org.apache.aries.subsystem.core.archive.ExportPackageHeader;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityCapability;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemExportServiceCapability;
import org.apache.aries.subsystem.core.archive.SubsystemExportServiceHeader;
import org.apache.aries.subsystem.core.internal.AbstractAction;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.CustomResources;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.StartResourceComparator;
import org.apache.aries.subsystem.core.internal.StopAction;
import org.apache.aries.subsystem.core.internal.Utils;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartAction
extends AbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(StartAction.class);
    private final Coordination coordination;
    private final BasicSubsystem instigator;
    private final boolean resolveOnly;

    public StartAction(BasicSubsystem instigator, BasicSubsystem requestor, BasicSubsystem target) {
        this(instigator, requestor, target, false);
    }

    public StartAction(BasicSubsystem instigator, BasicSubsystem requestor, BasicSubsystem target, boolean resolveOnly) {
        this(instigator, requestor, target, null, resolveOnly);
    }

    public StartAction(BasicSubsystem instigator, BasicSubsystem requestor, BasicSubsystem target, Coordination coordination) {
        this(instigator, requestor, target, coordination, false);
    }

    public StartAction(BasicSubsystem instigator, BasicSubsystem requestor, BasicSubsystem target, Coordination coordination, boolean resolveOnly) {
        super(requestor, target, false);
        this.instigator = instigator;
        this.coordination = coordination;
        this.resolveOnly = resolveOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run() {
        Subsystem.State state = this.target.getState();
        if (EnumSet.of(Subsystem.State.INSTALL_FAILED, Subsystem.State.UNINSTALLED, Subsystem.State.UNINSTALLING).contains(state)) {
            throw new SubsystemException("Cannot stop from state " + state);
        }
        if (EnumSet.of(Subsystem.State.INSTALLING, Subsystem.State.RESOLVING, Subsystem.State.STARTING, Subsystem.State.STOPPING).contains(state)) {
            this.waitForStateChange(state);
            return new StartAction(this.instigator, this.requestor, this.target, this.coordination).run();
        }
        if (Subsystem.State.ACTIVE.equals((Object)state)) {
            return null;
        }
        if (!(Utils.isContent(this.requestor, this.target) || Utils.isDependency(this.requestor, this.target) || this.instigator.equals(this.target) || !this.instigator.isRoot() || this.target.isReadyToStart())) {
            return null;
        }
        Coordination coordination = this.coordination;
        if (coordination == null) {
            coordination = Utils.createCoordination(this.target);
        }
        try {
            if (Subsystem.State.INSTALLED.equals((Object)state)) {
                StartAction.resolve(this.target);
            }
            if (this.resolveOnly) {
                Object var3_3 = null;
                return var3_3;
            }
            this.target.setState(Subsystem.State.STARTING);
            ArrayList<Resource> resources = new ArrayList<Resource>(Activator.getInstance().getSubsystems().getResourcesReferencedBy(this.target));
            SubsystemContentHeader header = this.target.getSubsystemManifest().getSubsystemContentHeader();
            if (header != null) {
                Collections.sort(resources, new StartResourceComparator(header));
            }
            for (Resource resource : resources) {
                this.startResource(resource, coordination);
            }
            this.target.setState(Subsystem.State.ACTIVE);
        }
        catch (Throwable t) {
            coordination.fail(t);
        }
        finally {
            try {
                if (coordination.getName().equals(Utils.computeCoordinationName((Subsystem)this.target))) {
                    coordination.end();
                }
            }
            catch (CoordinationException e) {
                this.target.setState(Subsystem.State.RESOLVED);
                Throwable t = e.getCause();
                if (t instanceof SubsystemException) {
                    throw (SubsystemException)t;
                }
                throw new SubsystemException(t);
            }
        }
        return null;
    }

    private static Collection<Bundle> getBundles(BasicSubsystem subsystem) {
        Collection<Resource> constituents = Activator.getInstance().getSubsystems().getConstituents(subsystem);
        ArrayList<Bundle> result = new ArrayList<Bundle>(constituents.size());
        for (Resource resource : constituents) {
            if (!(resource instanceof BundleRevision)) continue;
            result.add(((BundleRevision)resource).getBundle());
        }
        result.trimToSize();
        return result;
    }

    private static void resolve(BasicSubsystem subsystem) {
        if (Subsystem.State.INSTALLED.equals((Object)subsystem.getState())) {
            subsystem.setState(Subsystem.State.RESOLVING);
        }
        try {
            if (!subsystem.isRoot()) {
                Collection<Bundle> bundles;
                for (Resource dep : Activator.getInstance().getSubsystems().getResourcesReferencedBy(subsystem)) {
                    if (!(dep instanceof BasicSubsystem) || Activator.getInstance().getSubsystems().getChildren(subsystem).contains(dep) || Subsystem.State.INSTALLED != ((BasicSubsystem)dep).getState()) continue;
                    StartAction.resolve((BasicSubsystem)dep);
                }
                for (Subsystem child : Activator.getInstance().getSubsystems().getChildren(subsystem)) {
                    if (!Subsystem.State.INSTALLED.equals((Object)child.getState())) continue;
                    StartAction.resolve((BasicSubsystem)child);
                }
                FrameworkWiring frameworkWiring = (FrameworkWiring)Activator.getInstance().getBundleContext().getBundle(0L).adapt(FrameworkWiring.class);
                if (!frameworkWiring.resolveBundles(bundles = StartAction.getBundles(subsystem))) {
                    ArrayList<Bundle> unresolved = new ArrayList<Bundle>();
                    StringBuilder diagnostics = new StringBuilder();
                    diagnostics.append(String.format("Unable to resolve bundles for subsystem/version/id %s/%s/%s:\n", subsystem.getSymbolicName(), subsystem.getVersion(), subsystem.getSubsystemId()));
                    String fmt = "%d : STATE %s : %s : %s : %s";
                    for (Bundle bundle : bundles) {
                        if ((bundle.getState() & 4) != 4) {
                            unresolved.add(bundle);
                        }
                        String state = null;
                        switch (bundle.getState()) {
                            case 32: {
                                state = "ACTIVE";
                                break;
                            }
                            case 2: {
                                state = "INSTALLED";
                                break;
                            }
                            case 4: {
                                state = "RESOLVED";
                                break;
                            }
                            case 8: {
                                state = "STARTING";
                                break;
                            }
                            case 16: {
                                state = "STOPPING";
                                break;
                            }
                            case 1: {
                                state = "UNINSTALLED";
                                break;
                            }
                            default: {
                                state = "[" + Integer.toString(bundle.getState()) + "]";
                            }
                        }
                        diagnostics.append(String.format(fmt, bundle.getBundleId(), state, bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getLocation()));
                        diagnostics.append("\n");
                    }
                    logger.error(diagnostics.toString());
                    throw new SubsystemException("Framework could not resolve the bundles: " + unresolved);
                }
                StartAction.setExportIsolationPolicy(subsystem);
            }
            if (Subsystem.State.RESOLVING.equals((Object)subsystem.getState())) {
                subsystem.setState(Subsystem.State.RESOLVED);
            }
        }
        catch (Throwable t) {
            subsystem.setState(Subsystem.State.INSTALLED);
            if (t instanceof SubsystemException) {
                throw (SubsystemException)t;
            }
            throw new SubsystemException(t);
        }
    }

    private static void setExportIsolationPolicy(BasicSubsystem subsystem) throws InvalidSyntaxException, IOException, BundleException, URISyntaxException, ResolutionException {
        if (!subsystem.isComposite()) {
            return;
        }
        Region from = ((BasicSubsystem)subsystem.getParents().iterator().next()).getRegion();
        Region to = subsystem.getRegion();
        RegionFilterBuilder builder = from.getRegionDigraph().createRegionFilterBuilder();
        StartAction.setExportIsolationPolicy(builder, subsystem.getDeploymentManifest().getExportPackageHeader(), subsystem);
        StartAction.setExportIsolationPolicy(builder, subsystem.getDeploymentManifest().getProvideCapabilityHeader(), subsystem);
        StartAction.setExportIsolationPolicy(builder, subsystem.getDeploymentManifest().getSubsystemExportServiceHeader(), subsystem);
        RegionFilter regionFilter = builder.build();
        if (regionFilter.getSharingPolicy().isEmpty()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Establishing region connection: from=" + from + ", to=" + to + ", filter=" + regionFilter);
        }
        from.connectRegion(to, regionFilter);
    }

    private static void setExportIsolationPolicy(RegionFilterBuilder builder, ExportPackageHeader header, BasicSubsystem subsystem) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        String policy = "osgi.wiring.package";
        for (ExportPackageCapability capability : header.toCapabilities(subsystem)) {
            StringBuilder filter = new StringBuilder("(&");
            for (Map.Entry<String, Object> attribute : capability.getAttributes().entrySet()) {
                filter.append('(').append(attribute.getKey()).append('=').append(attribute.getValue()).append(')');
            }
            filter.append(')');
            if (logger.isDebugEnabled()) {
                logger.debug("Allowing " + policy + " of " + filter);
            }
            builder.allow(policy, filter.toString());
        }
    }

    private static void setExportIsolationPolicy(RegionFilterBuilder builder, ProvideCapabilityHeader header, BasicSubsystem subsystem) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        for (ProvideCapabilityHeader.Clause clause : header.getClauses()) {
            ProvideCapabilityCapability capability = new ProvideCapabilityCapability(clause, subsystem);
            String policy = capability.getNamespace();
            StringBuilder filter = new StringBuilder("(&");
            for (Map.Entry<String, Object> attribute : capability.getAttributes().entrySet()) {
                filter.append('(').append(attribute.getKey()).append('=').append(attribute.getValue()).append(')');
            }
            filter.append(')');
            if (logger.isDebugEnabled()) {
                logger.debug("Allowing " + policy + " of " + filter);
            }
            builder.allow(policy, filter.toString());
        }
    }

    private static void setExportIsolationPolicy(RegionFilterBuilder builder, SubsystemExportServiceHeader header, BasicSubsystem subsystem) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        String policy = "org.eclipse.equinox.allow.service";
        for (SubsystemExportServiceHeader.Clause clause : header.getClauses()) {
            SubsystemExportServiceCapability capability = new SubsystemExportServiceCapability(clause, subsystem);
            String filter = capability.getDirectives().get("filter");
            if (logger.isDebugEnabled()) {
                logger.debug("Allowing " + policy + " of " + filter);
            }
            builder.allow(policy, filter);
        }
    }

    private void startBundleResource(Resource resource, Coordination coordination) throws BundleException {
        if (this.target.isRoot()) {
            return;
        }
        if (Utils.isRegionContextBundle(resource)) {
            return;
        }
        final Bundle bundle = ((BundleRevision)resource).getBundle();
        if ((bundle.getState() & 0x28) != 0) {
            return;
        }
        if (logger.isDebugEnabled()) {
            int bundleStartLevel = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            Bundle systemBundle = Activator.getInstance().getBundleContext().getBundle(0L);
            int fwStartLevel = ((FrameworkStartLevel)systemBundle.adapt(FrameworkStartLevel.class)).getStartLevel();
            logger.debug("StartAction: starting bundle " + bundle.getSymbolicName() + " " + bundle.getVersion().toString() + " bundleStartLevel=" + bundleStartLevel + " frameworkStartLevel=" + fwStartLevel);
        }
        bundle.start(3);
        if (logger.isDebugEnabled()) {
            logger.debug("StartAction: bundle " + bundle.getSymbolicName() + " " + bundle.getVersion().toString() + " started correctly");
        }
        if (coordination == null) {
            return;
        }
        coordination.addParticipant(new Participant(){

            public void ended(Coordination coordination) throws Exception {
            }

            public void failed(Coordination coordination) throws Exception {
                bundle.stop();
            }
        });
    }

    private void startResource(Resource resource, Coordination coordination) throws BundleException, IOException {
        String type = ResourceHelper.getTypeAttribute(resource);
        if ("osgi.subsystem.application".equals(type) || "osgi.subsystem.composite".equals(type) || "osgi.subsystem.feature".equals(type)) {
            this.startSubsystemResource(resource, coordination);
        } else if ("osgi.bundle".equals(type)) {
            this.startBundleResource(resource, coordination);
        } else if (!"osgi.fragment".equals(type) && !this.startCustomHandler(resource, type, coordination)) {
            throw new SubsystemException("Unsupported resource type: " + type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startCustomHandler(Resource resource, String type, Coordination coordination) {
        ContentHandler customHandler;
        ServiceReference<ContentHandler> customHandlerRef = CustomResources.getCustomContentHandler(this.target, type);
        if (customHandlerRef != null && (customHandler = (ContentHandler)this.target.getBundleContext().getService(customHandlerRef)) != null) {
            try {
                customHandler.start(ResourceHelper.getSymbolicNameAttribute(resource), type, (Subsystem)this.target, coordination);
                boolean bl = true;
                return bl;
            }
            finally {
                this.target.getBundleContext().ungetService(customHandlerRef);
            }
        }
        return false;
    }

    private void startSubsystemResource(Resource resource, Coordination coordination) throws IOException {
        final BasicSubsystem subsystem = (BasicSubsystem)resource;
        if (Utils.isContent(this.target, subsystem)) {
            subsystem.setAutostart(true);
        }
        new StartAction(this.instigator, this.target, subsystem, coordination).run();
        if (coordination == null) {
            return;
        }
        coordination.addParticipant(new Participant(){

            public void ended(Coordination coordination) throws Exception {
            }

            public void failed(Coordination coordination) throws Exception {
                new StopAction(StartAction.this.target, subsystem, !subsystem.isRoot()).run();
            }
        });
    }
}

