/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.DeployedContentHeader;
import org.apache.aries.subsystem.core.archive.DeploymentManifest;
import org.apache.aries.subsystem.core.archive.Header;
import org.apache.aries.subsystem.core.archive.ImportPackageHeader;
import org.apache.aries.subsystem.core.archive.ImportPackageRequirement;
import org.apache.aries.subsystem.core.archive.ProvisionResourceHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleHeader;
import org.apache.aries.subsystem.core.archive.RequireBundleRequirement;
import org.apache.aries.subsystem.core.archive.RequireCapabilityHeader;
import org.apache.aries.subsystem.core.archive.RequireCapabilityRequirement;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentRequirement;
import org.apache.aries.subsystem.core.archive.SubsystemExportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemImportServiceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemImportServiceRequirement;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.DependencyCalculator;
import org.apache.aries.subsystem.core.internal.OsgiIdentityRequirement;
import org.apache.aries.subsystem.core.internal.RawSubsystemResource;
import org.apache.aries.subsystem.core.internal.RepositoryServiceRepository;
import org.apache.aries.subsystem.core.internal.ResolveContext;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.TranslationFile;
import org.apache.aries.subsystem.core.internal.Utils;
import org.apache.aries.subsystem.core.repository.Repository;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class SubsystemResource
implements Resource {
    private Region region;
    private final List<Capability> capabilities;
    private final DeploymentManifest deploymentManifest;
    private final Collection<Resource> installableContent = new HashSet<Resource>();
    private final Collection<Resource> installableDependencies = new HashSet<Resource>();
    private final Collection<Resource> mandatoryResources = new HashSet<Resource>();
    private final Collection<DeployedContentHeader.Clause> missingResources = new HashSet<DeployedContentHeader.Clause>();
    private final Collection<Resource> optionalResources = new HashSet<Resource>();
    private final BasicSubsystem parent;
    private final RawSubsystemResource resource;
    private final Collection<Resource> sharedContent = new HashSet<Resource>();
    private final Collection<Resource> sharedDependencies = new HashSet<Resource>();

    public SubsystemResource(String location, IDirectory content, BasicSubsystem parent) throws URISyntaxException, IOException, ResolutionException, BundleException, InvalidSyntaxException {
        this(new RawSubsystemResource(location, content, parent), parent);
    }

    public SubsystemResource(RawSubsystemResource resource, BasicSubsystem parent) throws IOException, BundleException, InvalidSyntaxException, URISyntaxException {
        this.parent = parent;
        this.resource = resource;
        this.computeContentResources(resource.getDeploymentManifest());
        this.capabilities = this.computeCapabilities();
        this.computeDependencies(resource.getDeploymentManifest());
        this.deploymentManifest = this.computeDeploymentManifest();
    }

    public SubsystemResource(File file) throws IOException, URISyntaxException, ResolutionException, BundleException, InvalidSyntaxException {
        this(FileSystem.getFSRoot((File)file));
    }

    public SubsystemResource(IDirectory directory) throws IOException, URISyntaxException, ResolutionException, BundleException, InvalidSyntaxException {
        this.parent = null;
        this.resource = new RawSubsystemResource(directory, this.parent);
        this.deploymentManifest = this.resource.getDeploymentManifest();
        this.computeContentResources(this.deploymentManifest);
        this.capabilities = this.computeCapabilities();
        this.computeDependencies(this.deploymentManifest);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubsystemResource)) {
            return false;
        }
        SubsystemResource that = (SubsystemResource)o;
        return this.getLocation().equals(that.getLocation());
    }

    public List<Capability> getCapabilities(String namespace) {
        return Collections.unmodifiableList(this.capabilities);
    }

    private List<Capability> computeCapabilities() throws InvalidSyntaxException {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        if (this.isScoped()) {
            this.computeScopedCapabilities(capabilities);
        } else {
            this.computeUnscopedCapabilities(capabilities);
        }
        return capabilities;
    }

    private void computeUnscopedCapabilities(List<Capability> capabilities) {
        capabilities.addAll(this.resource.getCapabilities(null));
        for (Resource r : this.getContentResources()) {
            capabilities.addAll(r.getCapabilities(null));
        }
    }

    private void computeScopedCapabilities(List<Capability> capabilities) throws InvalidSyntaxException {
        capabilities.addAll(this.resource.getCapabilities(null));
        this.computeOsgiServiceCapabilities(capabilities);
    }

    private void computeOsgiServiceCapabilities(List<Capability> capabilities) throws InvalidSyntaxException {
        SubsystemExportServiceHeader header = this.getSubsystemManifest().getSubsystemExportServiceHeader();
        if (header == null) {
            return;
        }
        for (Resource resource : this.getContentResources()) {
            capabilities.addAll(header.toCapabilities(resource));
        }
    }

    public DeploymentManifest getDeploymentManifest() {
        return this.deploymentManifest;
    }

    public long getId() {
        return this.resource.getId();
    }

    public Collection<Resource> getInstallableContent() {
        return this.installableContent;
    }

    public Collection<Resource> getInstallableDependencies() {
        return this.installableDependencies;
    }

    public Repository getLocalRepository() {
        return this.resource.getLocalRepository();
    }

    public String getLocation() {
        return this.resource.getLocation().getValue();
    }

    Collection<Resource> getMandatoryResources() {
        return this.mandatoryResources;
    }

    public Collection<DeployedContentHeader.Clause> getMissingResources() {
        return this.missingResources;
    }

    Collection<Resource> getOptionalResources() {
        return this.optionalResources;
    }

    public Collection<BasicSubsystem> getParents() {
        if (this.parent == null) {
            Header<?> header = this.getDeploymentManifest().getHeaders().get("AriesSubsystem-Parents");
            if (header == null) {
                return Collections.emptyList();
            }
            String[] parentIds = header.getValue().split(",");
            ArrayList<BasicSubsystem> result = new ArrayList<BasicSubsystem>(parentIds.length);
            for (String parentId : parentIds) {
                result.add(Activator.getInstance().getSubsystems().getSubsystemById(Long.valueOf(parentId)));
            }
            return result;
        }
        return Collections.singleton(this.parent);
    }

    public synchronized Region getRegion() throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (this.region == null) {
            this.region = this.createRegion(this.getId());
            Coordination coordination = Activator.getInstance().getCoordinator().peek();
            coordination.addParticipant(new Participant(){

                public void ended(Coordination arg0) throws Exception {
                }

                public void failed(Coordination arg0) throws Exception {
                    if (SubsystemResource.this.isScoped()) {
                        SubsystemResource.this.region.getRegionDigraph().removeRegion(SubsystemResource.this.region);
                    }
                }
            });
            if (!this.isApplication()) {
                this.setImportIsolationPolicy();
            }
        }
        return this.region;
    }

    public List<Requirement> getRequirements(String namespace) {
        if (this.isScoped()) {
            return this.resource.getRequirements(namespace);
        }
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        result.addAll(this.resource.getRequirements(namespace));
        for (Resource r : this.getContentResources()) {
            result.addAll(r.getRequirements(namespace));
        }
        result.trimToSize();
        return result;
    }

    public Collection<Resource> getSharedContent() {
        return this.sharedContent;
    }

    public Collection<Resource> getSharedDependencies() {
        return this.sharedDependencies;
    }

    public SubsystemManifest getSubsystemManifest() {
        return this.resource.getSubsystemManifest();
    }

    public Collection<TranslationFile> getTranslations() {
        return this.resource.getTranslations();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getLocation().hashCode();
        return result;
    }

    private void addContentResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.isMandatory(resource)) {
            this.mandatoryResources.add(resource);
        } else {
            this.optionalResources.add(resource);
        }
        if (this.isInstallable(resource)) {
            this.installableContent.add(resource);
        } else {
            this.sharedContent.add(resource);
        }
    }

    private void addDependency(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.isInstallable(resource)) {
            this.installableDependencies.add(resource);
        } else {
            this.sharedDependencies.add(resource);
        }
    }

    private void addMissingResource(DeployedContentHeader.Clause resource) {
        this.missingResources.add(resource);
    }

    private void addSubsystemServiceImportToSharingPolicy(RegionFilterBuilder builder) throws InvalidSyntaxException, BundleException, IOException, URISyntaxException {
        builder.allow("org.eclipse.equinox.allow.service", "(&(" + "objectClass" + '=' + Subsystem.class.getName() + ")(" + "org.apache.aries.subsystem.service.regions" + '=' + this.getRegion().getName() + "))");
    }

    private void addSubsystemServiceImportToSharingPolicy(RegionFilterBuilder builder, Region to) throws InvalidSyntaxException, BundleException, IOException, URISyntaxException {
        Region root = Activator.getInstance().getSubsystems().getRootSubsystem().getRegion();
        if (to.getName().equals(root.getName())) {
            this.addSubsystemServiceImportToSharingPolicy(builder);
        } else {
            to = root;
            builder = to.getRegionDigraph().createRegionFilterBuilder();
            this.addSubsystemServiceImportToSharingPolicy(builder);
            RegionFilter regionFilter = builder.build();
            this.getRegion().connectRegion(to, regionFilter);
        }
    }

    private void computeContentResources(DeploymentManifest manifest) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (manifest == null) {
            this.computeContentResources(this.getSubsystemManifest());
        } else {
            DeployedContentHeader header = manifest.getDeployedContentHeader();
            if (header == null) {
                return;
            }
            for (DeployedContentHeader.Clause clause : header.getClauses()) {
                Resource resource = this.findContent(clause);
                if (resource == null) {
                    this.addMissingResource(clause);
                    continue;
                }
                this.addContentResource(resource);
            }
        }
    }

    private void computeContentResources(SubsystemManifest manifest) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        SubsystemContentHeader contentHeader = manifest.getSubsystemContentHeader();
        if (contentHeader == null) {
            return;
        }
        for (SubsystemContentHeader.Clause clause : contentHeader.getClauses()) {
            SubsystemContentRequirement requirement = clause.toRequirement(this);
            Resource resource = this.findContent(requirement);
            if (resource == null) {
                if (!clause.isMandatory()) continue;
                throw new SubsystemException("A required content resource could not be found. This means the resource was either missing or not recognized as a supported resource format due to, for example, an invalid bundle manifest or blueprint XML file. Turn on debug logging for more information. The resource was: " + requirement);
            }
            this.addContentResource(resource);
        }
    }

    private void computeDependencies(DeploymentManifest manifest) {
        if (manifest == null) {
            this.computeDependencies(this.getSubsystemManifest());
        } else {
            ProvisionResourceHeader header = manifest.getProvisionResourceHeader();
            if (header == null) {
                return;
            }
            for (ProvisionResourceHeader.Clause clause : header.getClauses()) {
                Resource resource = this.findDependency(clause);
                if (resource == null) {
                    throw new SubsystemException("A required dependency could not be found. This means the resource was either missing or not recognized as a supported resource format due to, for example, an invalid bundle manifest or blueprint XML file. Turn on debug logging for more information. The resource was: " + resource);
                }
                this.addDependency(resource);
            }
        }
    }

    private void computeDependencies(SubsystemManifest manifest) {
        SubsystemContentHeader contentHeader = manifest.getSubsystemContentHeader();
        try {
            Map resolution = Activator.getInstance().getResolver().resolve(this.createResolveContext());
            this.setImportIsolationPolicy(resolution);
            for (Map.Entry entry : resolution.entrySet()) {
                Resource key = (Resource)entry.getKey();
                String type = ResourceHelper.getTypeAttribute(key);
                if (!"org.apache.aries.subsystem.resource.synthesized".equals(type) && !contentHeader.contains(key)) {
                    this.addDependency(key);
                }
                for (Wire wire : (List)entry.getValue()) {
                    Resource provider = wire.getProvider();
                    type = ResourceHelper.getTypeAttribute(provider);
                    if ("org.apache.aries.subsystem.resource.synthesized".equals(type) || contentHeader.contains(provider)) continue;
                    this.addDependency(provider);
                }
            }
        }
        catch (ResolutionException e) {
            throw new SubsystemException((Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof SubsystemException) {
                throw (SubsystemException)((Object)e);
            }
            if (e instanceof SecurityException) {
                throw (SecurityException)e;
            }
            throw new SubsystemException((Throwable)e);
        }
    }

    private DeployedContentHeader computeDeployedContentHeader() {
        Collection<Resource> content = this.getContentResources();
        if (content.isEmpty()) {
            return null;
        }
        return DeployedContentHeader.newInstance(content);
    }

    private DeploymentManifest computeDeploymentManifest() throws IOException {
        DeploymentManifest result = this.computeExistingDeploymentManifest();
        if (result != null) {
            return result;
        }
        result = new DeploymentManifest.Builder().manifest(this.resource.getSubsystemManifest()).header(this.computeDeployedContentHeader()).header(this.computeProvisionResourceHeader()).build();
        return result;
    }

    private DeploymentManifest computeExistingDeploymentManifest() throws IOException {
        return this.resource.getDeploymentManifest();
    }

    private ProvisionResourceHeader computeProvisionResourceHeader() {
        Collection<Resource> dependencies = this.getDependencies();
        if (dependencies.isEmpty()) {
            return null;
        }
        return ProvisionResourceHeader.newInstance(dependencies);
    }

    private Region createRegion(long id) throws BundleException {
        if (!this.isScoped()) {
            return this.getParents().iterator().next().getRegion();
        }
        Activator activator = Activator.getInstance();
        RegionDigraph digraph = activator.getRegionDigraph();
        if (this.getParents().isEmpty()) {
            return digraph.getRegion(activator.getBundleContext().getBundle());
        }
        String name = this.getSubsystemManifest().getSubsystemSymbolicNameHeader().getSymbolicName() + ';' + this.getSubsystemManifest().getSubsystemVersionHeader().getVersion() + ';' + this.getSubsystemManifest().getSubsystemTypeHeader().getType() + ';' + Long.toString(id);
        Region region = digraph.getRegion(name);
        if (region == null) {
            return digraph.createRegion(name);
        }
        return region;
    }

    private org.osgi.service.resolver.ResolveContext createResolveContext() {
        return new ResolveContext(this);
    }

    private Resource findContent(Requirement requirement) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        Collection<Capability> capabilities;
        Map<Requirement, Collection<Capability>> map;
        if (this.isUnscoped() && (map = Activator.getInstance().getSystemRepository().findProviders(Collections.singleton(requirement))).containsKey(requirement)) {
            capabilities = map.get(requirement);
            for (Capability capability : capabilities) {
                Resource provider = capability.getResource();
                if (!(provider instanceof BundleRevision ? this.getRegion().contains(((BundleRevision)provider).getBundle()) : provider instanceof BasicSubsystem && this.getRegion().equals(((BasicSubsystem)provider).getRegion()))) continue;
                return provider;
            }
        }
        if ((capabilities = (map = this.resource.getLocalRepository().findProviders(Collections.singleton(requirement))).get(requirement)).isEmpty()) {
            capabilities = new RepositoryServiceRepository().findProviders(requirement);
        }
        if (capabilities.isEmpty()) {
            return null;
        }
        for (Capability capability : capabilities) {
            if ("osgi.fragment".equals(capability.getAttributes().get("type"))) continue;
            return capability.getResource();
        }
        return capabilities.iterator().next().getResource();
    }

    private Resource findContent(DeployedContentHeader.Clause clause) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        long resourceId;
        Attribute attribute = clause.getAttribute("resourceId");
        long l = resourceId = attribute == null ? -1L : Long.parseLong(String.valueOf(attribute.getValue()));
        if (resourceId != -1L) {
            String type = clause.getType();
            if ("osgi.bundle".equals(type) || "osgi.fragment".equals(type)) {
                Bundle resource = Activator.getInstance().getBundleContext().getBundle(0L).getBundleContext().getBundle(resourceId);
                if (resource == null) {
                    return null;
                }
                return (Resource)resource.adapt(BundleRevision.class);
            }
            return Activator.getInstance().getSubsystems().getSubsystemById(resourceId);
        }
        return this.findContent(clause.toRequirement(this));
    }

    private Resource findDependency(ProvisionResourceHeader.Clause clause) {
        long resourceId;
        Attribute attribute = clause.getAttribute("resourceId");
        long l = resourceId = attribute == null ? -1L : Long.parseLong(String.valueOf(attribute.getValue()));
        if (resourceId != -1L) {
            String type = clause.getType();
            if ("osgi.bundle".equals(type) || "osgi.fragment".equals(type)) {
                return (Resource)Activator.getInstance().getBundleContext().getBundle(0L).getBundleContext().getBundle(resourceId).adapt(BundleRevision.class);
            }
            return Activator.getInstance().getSubsystems().getSubsystemById(resourceId);
        }
        OsgiIdentityRequirement requirement = new OsgiIdentityRequirement(clause.getPath(), clause.getDeployedVersion(), clause.getType(), true);
        List capabilities = this.createResolveContext().findProviders((Requirement)requirement);
        if (capabilities.isEmpty()) {
            return null;
        }
        return ((Capability)capabilities.get(0)).getResource();
    }

    private Collection<Resource> getContentResources() {
        ArrayList<Resource> result = new ArrayList<Resource>(this.installableContent.size() + this.sharedContent.size());
        result.addAll(this.installableContent);
        result.addAll(this.sharedContent);
        return result;
    }

    private Collection<Resource> getDependencies() {
        ArrayList<Resource> result = new ArrayList<Resource>(this.installableDependencies.size() + this.sharedDependencies.size());
        result.addAll(this.installableDependencies);
        result.addAll(this.sharedDependencies);
        return result;
    }

    boolean isApplication() {
        String type = this.resource.getSubsystemManifest().getSubsystemTypeHeader().getType();
        return "osgi.subsystem.application".equals(type);
    }

    boolean isComposite() {
        String type = this.resource.getSubsystemManifest().getSubsystemTypeHeader().getType();
        return "osgi.subsystem.composite".equals(type);
    }

    boolean isContent(Resource resource) {
        return this.installableContent.contains(resource) || this.sharedContent.contains(resource);
    }

    private boolean isInstallable(Resource resource) {
        return !this.isShared(resource);
    }

    private boolean isMandatory(Resource resource) {
        SubsystemContentHeader header = this.resource.getSubsystemManifest().getSubsystemContentHeader();
        if (header == null) {
            return false;
        }
        return header.isMandatory(resource);
    }

    boolean isRoot() {
        return BasicSubsystem.ROOT_LOCATION.equals(this.getLocation());
    }

    private boolean isShared(Resource resource) {
        return Utils.isSharedResource(resource);
    }

    private boolean isScoped() {
        return this.isApplication() || this.isComposite();
    }

    private boolean isUnscoped() {
        return !this.isScoped();
    }

    private void setImportIsolationPolicy(Map<Resource, List<Wire>> resolution) throws Exception {
        if (!this.isApplication()) {
            return;
        }
        SubsystemContentHeader contentHeader = this.getSubsystemManifest().getSubsystemContentHeader();
        Region from = this.getRegion();
        Region to = this.getParents().iterator().next().getRegion();
        RegionFilterBuilder builder = from.getRegionDigraph().createRegionFilterBuilder();
        this.addSubsystemServiceImportToSharingPolicy(builder, to);
        for (Resource resource : resolution.keySet()) {
            List<Wire> wires = resolution.get(resource);
            for (Wire wire : wires) {
                String filter;
                Resource provider = wire.getProvider();
                if (contentHeader.contains(provider) || !(wire.getCapability() instanceof DependencyCalculator.MissingCapability) && "org.apache.aries.subsystem.resource.synthesized".equals(ResourceHelper.getTypeAttribute(provider))) continue;
                Requirement requirement = wire.getRequirement();
                ArrayList<String> namespaces = new ArrayList<String>(2);
                namespaces.add(requirement.getNamespace());
                if ("osgi.service".equals(namespaces.get(0))) {
                    namespaces.add("org.eclipse.equinox.allow.service");
                }
                if ((filter = (String)requirement.getDirectives().get("filter")) == null) {
                    for (String namespace : namespaces) {
                        builder.allowAll(namespace);
                    }
                    continue;
                }
                for (String namespace : namespaces) {
                    builder.allow(namespace, filter);
                }
            }
        }
        this.setImplicitAccessToNativeAndEECapabilities(builder);
        RegionFilter regionFilter = builder.build();
        from.connectRegion(to, regionFilter);
    }

    private void setImportIsolationPolicy() throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        Region region;
        if (this.isRoot() || !this.isScoped()) {
            return;
        }
        Region from = region = this.getRegion();
        RegionFilterBuilder builder = from.getRegionDigraph().createRegionFilterBuilder();
        Region to = this.getParents().iterator().next().getRegion();
        this.addSubsystemServiceImportToSharingPolicy(builder, to);
        if (this.isScoped()) {
            AbstractClauseBasedHeader header = this.getSubsystemManifest().getImportPackageHeader();
            this.setImportIsolationPolicy(builder, (ImportPackageHeader)header);
            header = this.getSubsystemManifest().getRequireCapabilityHeader();
            this.setImportIsolationPolicy(builder, (RequireCapabilityHeader)header);
            header = this.getSubsystemManifest().getSubsystemImportServiceHeader();
            this.setImportIsolationPolicy(builder, (SubsystemImportServiceHeader)header);
            header = this.getSubsystemManifest().getRequireBundleHeader();
            this.setImportIsolationPolicy(builder, (RequireBundleHeader)header);
            this.setImplicitAccessToNativeAndEECapabilities(builder);
        }
        RegionFilter regionFilter = builder.build();
        from.connectRegion(to, regionFilter);
    }

    private void setImportIsolationPolicy(RegionFilterBuilder builder, ImportPackageHeader header) throws InvalidSyntaxException {
        String policy = "osgi.wiring.package";
        if (header == null) {
            return;
        }
        for (ImportPackageHeader.Clause clause : header.getClauses()) {
            ImportPackageRequirement requirement = new ImportPackageRequirement(clause, this);
            String filter = requirement.getDirectives().get("filter");
            builder.allow(policy, filter);
        }
    }

    private void setImportIsolationPolicy(RegionFilterBuilder builder, RequireBundleHeader header) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        for (RequireBundleHeader.Clause clause : header.getClauses()) {
            RequireBundleRequirement requirement = new RequireBundleRequirement(clause, this);
            String policy = "osgi.wiring.bundle";
            String filter = requirement.getDirectives().get("filter");
            builder.allow(policy, filter);
        }
    }

    private void setImportIsolationPolicy(RegionFilterBuilder builder, RequireCapabilityHeader header) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        for (RequireCapabilityHeader.Clause clause : header.getClauses()) {
            RequireCapabilityRequirement requirement = new RequireCapabilityRequirement(clause, this);
            String policy = requirement.getNamespace();
            String filter = requirement.getDirectives().get("filter");
            if (filter == null) {
                builder.allowAll(policy);
                continue;
            }
            builder.allow(policy, filter);
        }
    }

    private void setImplicitAccessToNativeAndEECapabilities(RegionFilterBuilder builder) {
        builder.allowAll("osgi.ee");
        builder.allowAll("osgi.native");
    }

    private void setImportIsolationPolicy(RegionFilterBuilder builder, SubsystemImportServiceHeader header) throws InvalidSyntaxException {
        if (header == null) {
            return;
        }
        for (SubsystemImportServiceHeader.Clause clause : header.getClauses()) {
            SubsystemImportServiceRequirement requirement = new SubsystemImportServiceRequirement(clause, this);
            String policy = "org.eclipse.equinox.allow.service";
            String filter = requirement.getDirectives().get("filter");
            builder.allow(policy, filter);
        }
    }
}

