/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.InstallResourceComparator;
import org.apache.aries.subsystem.core.internal.RawSubsystemResource;
import org.apache.aries.subsystem.core.internal.RegionContextBundleHelper;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Participant;
import org.osgi.service.subsystem.Subsystem;

public class SubsystemResourceInstaller
extends ResourceInstaller {
    public SubsystemResourceInstaller(Coordination coordination, Resource resource, BasicSubsystem subsystem) {
        super(coordination, resource, subsystem);
    }

    @Override
    public Resource install() throws Exception {
        if (this.resource instanceof BasicSubsystem) {
            return this.installAriesSubsystem((BasicSubsystem)this.resource);
        }
        if (this.resource instanceof RawSubsystemResource) {
            return this.installRawSubsystemResource((RawSubsystemResource)this.resource);
        }
        if (this.resource instanceof SubsystemResource) {
            return this.installSubsystemResource((SubsystemResource)this.resource);
        }
        return this.installRepositoryContent(this.resource);
    }

    private void addChild(final BasicSubsystem child) {
        if (this.provisionTo == null) {
            return;
        }
        if (this.resource.equals((Object)this.provisionTo)) {
            return;
        }
        Activator.getInstance().getSubsystems().addChild(this.provisionTo, child, !this.isDependency());
        this.coordination.addParticipant(new Participant(){

            public void ended(Coordination arg0) throws Exception {
            }

            public void failed(Coordination arg0) throws Exception {
                Activator.getInstance().getSubsystems().removeChild(SubsystemResourceInstaller.this.provisionTo, child);
            }
        });
    }

    private void addSubsystem(final BasicSubsystem subsystem) {
        Activator.getInstance().getSubsystems().addSubsystem(subsystem);
        this.coordination.addParticipant(new Participant(){

            public void ended(Coordination arg0) throws Exception {
            }

            public void failed(Coordination arg0) throws Exception {
                Activator.getInstance().getSubsystems().removeSubsystem(subsystem);
            }
        });
    }

    private BasicSubsystem installAriesSubsystem(BasicSubsystem subsystem) throws Exception {
        this.addChild(subsystem);
        this.addReference(subsystem);
        this.addConstituent(subsystem);
        this.addSubsystem(subsystem);
        this.installRegionContextBundle(subsystem);
        if (Subsystem.State.INSTALLING.equals((Object)subsystem.getState())) {
            Activator.getInstance().getSubsystemServiceRegistrar().register(subsystem, this.subsystem);
        }
        InstallResourceComparator comparator = new InstallResourceComparator();
        ArrayList<Resource> dependencies = new ArrayList<Resource>(subsystem.getResource().getInstallableDependencies());
        Collections.sort(dependencies, comparator);
        for (Resource dependency : dependencies) {
            ResourceInstaller.newInstance(this.coordination, dependency, subsystem).install();
        }
        for (Resource dependency : subsystem.getResource().getSharedDependencies()) {
            if (dependency.equals((Object)this.subsystem)) continue;
            ResourceInstaller.newInstance(this.coordination, dependency, subsystem).install();
        }
        for (Resource content : subsystem.getResource().getSharedContent()) {
            ResourceInstaller.newInstance(this.coordination, content, subsystem).install();
        }
        if (Subsystem.State.INSTALLING.equals((Object)subsystem.getState())) {
            ArrayList<Resource> installableContent = new ArrayList<Resource>(subsystem.getResource().getInstallableContent());
            Collections.sort(installableContent, comparator);
            for (Resource content : installableContent) {
                ResourceInstaller.newInstance(this.coordination, content, subsystem).install();
            }
        }
        if (Subsystem.State.INSTALLING.equals((Object)subsystem.getState())) {
            subsystem.setState(Subsystem.State.INSTALLED);
        } else {
            Activator.getInstance().getSubsystemServiceRegistrar().register(subsystem, this.subsystem);
        }
        return subsystem;
    }

    private BasicSubsystem installRawSubsystemResource(RawSubsystemResource resource) throws Exception {
        SubsystemResource subsystemResource = new SubsystemResource(resource, this.provisionTo);
        return this.installSubsystemResource(subsystemResource);
    }

    private void installRegionContextBundle(final BasicSubsystem subsystem) throws Exception {
        if (!subsystem.isScoped()) {
            return;
        }
        RegionContextBundleHelper.installRegionContextBundle(subsystem, this.coordination);
        this.coordination.addParticipant(new Participant(){

            public void ended(Coordination coordination) throws Exception {
            }

            public void failed(Coordination coordination) throws Exception {
                RegionContextBundleHelper.uninstallRegionContextBundle(subsystem);
            }
        });
    }

    private BasicSubsystem installRepositoryContent(Resource resource) throws Exception {
        Method method = resource.getClass().getMethod("getContent", new Class[0]);
        InputStream is = (InputStream)method.invoke((Object)resource, new Object[0]);
        RawSubsystemResource rawSubsystemResource = new RawSubsystemResource(this.getLocation(), (IDirectory)FileSystem.getFSRoot((InputStream)is), this.subsystem);
        return this.installRawSubsystemResource(rawSubsystemResource);
    }

    private BasicSubsystem installSubsystemResource(SubsystemResource resource) throws Exception {
        BasicSubsystem subsystem = new BasicSubsystem(resource);
        this.installAriesSubsystem(subsystem);
        return subsystem;
    }
}

