/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.subsystem.core.archive.DynamicImportPackageHeader;
import org.apache.aries.subsystem.core.archive.DynamicImportPackageRequirement;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.RegionUpdater;
import org.apache.aries.subsystem.core.internal.StartAction;
import org.apache.aries.subsystem.core.internal.Subsystems;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraphVisitor;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.Subsystem;
import org.osgi.service.subsystem.SubsystemException;

public class WovenClassListener
implements org.osgi.framework.hooks.weaving.WovenClassListener {
    private final BundleContext context;
    private final Subsystems subsystems;

    public WovenClassListener(BundleContext context, Subsystems subsystems) {
        this.context = context;
        this.subsystems = subsystems;
    }

    public void modified(WovenClass wovenClass) {
        if (wovenClass.getState() != 2) {
            return;
        }
        List dynamicImports = wovenClass.getDynamicImports();
        if (dynamicImports.isEmpty()) {
            return;
        }
        BundleWiring wiring = wovenClass.getBundleWiring();
        Bundle bundle = wiring.getBundle();
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        BundleResourceInstaller.BundleConstituent constituent = new BundleResourceInstaller.BundleConstituent(null, revision);
        Collection<BasicSubsystem> basicSubsystems = this.subsystems.getSubsystemsByConstituent((Resource)constituent);
        BasicSubsystem subsystem = basicSubsystems.iterator().next();
        if ((subsystem = this.scopedSubsystem(subsystem)).getSubsystemId() == 0L) {
            return;
        }
        if (EnumSet.of(Subsystem.State.INSTALLING, Subsystem.State.INSTALLED).contains(subsystem.getState())) {
            AccessController.doPrivileged(new StartAction(subsystem, subsystem, subsystem, true));
        }
        Bundle systemBundle = this.context.getBundle("System Bundle");
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        HashMap<Region, RegionUpdaterInfo> updates = new HashMap<Region, RegionUpdaterInfo>();
        for (String dynamicImport : dynamicImports) {
            DynamicImportPackageHeader header = new DynamicImportPackageHeader(dynamicImport);
            List<DynamicImportPackageRequirement> requirements = header.toRequirements((Resource)revision);
            for (DynamicImportPackageRequirement requirement : requirements) {
                Collection providers = frameworkWiring.findProviders((Requirement)requirement);
                if (providers.isEmpty()) continue;
                this.addSharingPolicyUpdates(requirement, subsystem, providers, updates);
            }
        }
        for (RegionUpdaterInfo update : updates.values()) {
            RegionUpdater updater = new RegionUpdater(update.tail(), update.head());
            try {
                updater.addRequirements(update.requirements());
            }
            catch (IllegalStateException e) {
            }
            catch (Exception e) {
                throw new SubsystemException((Throwable)e);
            }
        }
    }

    private void addSharingPolicyUpdates(final DynamicImportPackageRequirement requirement, BasicSubsystem scopedSubsystem, final Collection<BundleCapability> providers, Map<Region, RegionUpdaterInfo> updates) {
        final ArrayList subsystems = new ArrayList();
        final HashMap<Region, BasicSubsystem> regionToSubsystem = new HashMap<Region, BasicSubsystem>();
        this.regionToSubsystem(scopedSubsystem, regionToSubsystem);
        scopedSubsystem.getRegion().visitSubgraph(new RegionDigraphVisitor(){
            private final AtomicBoolean abort = new AtomicBoolean();
            private final Deque<BasicSubsystem> deque = new ArrayDeque<BasicSubsystem>();

            public void postEdgeTraverse(RegionFilter filter) {
                if (this.deque.isEmpty() || this.abort.getAndSet(false)) {
                    return;
                }
                BasicSubsystem subsystem = this.deque.pop();
                if (filter.isAllowed((BundleCapability)providers.iterator().next())) {
                    return;
                }
                subsystems.add(subsystem);
            }

            public boolean preEdgeTraverse(RegionFilter filter) {
                return !this.deque.isEmpty();
            }

            public boolean visit(Region region) {
                BasicSubsystem subsystem = (BasicSubsystem)regionToSubsystem.get(region);
                if (subsystem == null) {
                    return false;
                }
                if (!this.deque.isEmpty() && !WovenClassListener.this.scopedParent(this.deque.getFirst()).equals(subsystem)) {
                    this.abort.set(true);
                    return false;
                }
                this.deque.push(subsystem);
                for (BundleCapability provider : providers) {
                    BundleRevision br = provider.getResource();
                    if (!region.contains(br.getBundle()) || requirement.getPackageName().contains("*")) continue;
                    this.deque.pop();
                    return false;
                }
                if (region.getEdges().isEmpty()) {
                    this.deque.pop();
                }
                return true;
            }
        });
        for (BasicSubsystem subsystem : subsystems) {
            Region tail = subsystem.getRegion();
            Region head = this.scopedParent(subsystem).getRegion();
            RegionUpdaterInfo info = updates.get(tail);
            if (info == null) {
                info = new RegionUpdaterInfo(tail, head);
                updates.put(tail, info);
            }
            info.requirement(requirement);
        }
    }

    private void regionToSubsystem(BasicSubsystem subsystem, Map<Region, BasicSubsystem> map) {
        map.put(subsystem.getRegion(), subsystem);
        subsystem = this.scopedParent(subsystem);
        if (subsystem == null) {
            return;
        }
        this.regionToSubsystem(subsystem, map);
    }

    private BasicSubsystem scopedParent(BasicSubsystem subsystem) {
        Collection<Subsystem> parents = subsystem.getParents();
        if (parents.isEmpty()) {
            return null;
        }
        subsystem = (BasicSubsystem)parents.iterator().next();
        return this.scopedSubsystem(subsystem);
    }

    private BasicSubsystem scopedSubsystem(BasicSubsystem subsystem) {
        while (!subsystem.isScoped()) {
            subsystem = (BasicSubsystem)subsystem.getParents().iterator().next();
        }
        return subsystem;
    }

    private static class RegionUpdaterInfo {
        private final Region head;
        private final Collection<DynamicImportPackageRequirement> requirements;
        private final Region tail;

        public RegionUpdaterInfo(Region tail, Region head) {
            this.tail = tail;
            this.head = head;
            this.requirements = new ArrayList<DynamicImportPackageRequirement>();
        }

        public Region head() {
            return this.head;
        }

        public void requirement(DynamicImportPackageRequirement requirement) {
            this.requirements.add(requirement);
        }

        public Collection<DynamicImportPackageRequirement> requirements() {
            return this.requirements;
        }

        public Region tail() {
            return this.tail;
        }
    }
}

