/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.itest;

import java.io.File;
import java.io.InputStream;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichBundleContext
implements BundleContext {
    public static final long DEFAULT_TIMEOUT = 15000L;
    private final BundleContext delegate;

    public RichBundleContext(BundleContext delegate) {
        this.delegate = delegate;
    }

    public <T> T getService(Class<T> type) {
        return this.getService(type, null, 15000L);
    }

    public <T> T getService(Class<T> type, long timeout) {
        return this.getService(type, null, timeout);
    }

    public <T> T getService(Class<T> type, String filter) {
        return this.getService(type, filter, 15000L);
    }

    public <T> T getService(Class<T> type, String filter, long timeout) {
        ServiceTracker tracker = null;
        try {
            String flt = filter != null ? (filter.startsWith("(") ? "(&(objectClass=" + type.getName() + ")" + filter + ")" : "(&(objectClass=" + type.getName() + ")(" + filter + "))") : "(objectClass=" + type.getName() + ")";
            Filter osgiFilter = FrameworkUtil.createFilter((String)flt);
            tracker = new ServiceTracker(this.delegate, osgiFilter, null);
            tracker.open();
            T svc = type.cast(tracker.waitForService(timeout));
            if (svc == null) {
                System.out.println("Could not obtain a service in time, service-ref=" + tracker.getServiceReference() + ", time=" + System.currentTimeMillis());
                throw new RuntimeException("Gave up waiting for service " + flt);
            }
            return type.cast(svc);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Bundle getBundleByName(String symbolicName) {
        for (Bundle b : this.delegate.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        return null;
    }

    public String getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    public Bundle getBundle() {
        return this.delegate.getBundle();
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.delegate.installBundle(location, input);
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.delegate.installBundle(location);
    }

    public Bundle getBundle(long id) {
        return this.delegate.getBundle(id);
    }

    public Bundle[] getBundles() {
        return this.delegate.getBundles();
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.delegate.addServiceListener(listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        this.delegate.addServiceListener(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.delegate.removeServiceListener(listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.delegate.addBundleListener(listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.delegate.removeBundleListener(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.delegate.addFrameworkListener(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.delegate.removeFrameworkListener(listener);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        return this.delegate.registerService(clazzes, service, properties);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        return this.delegate.registerService(clazz, service, properties);
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.delegate.getServiceReferences(clazz, filter);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.delegate.getAllServiceReferences(clazz, filter);
    }

    public ServiceReference getServiceReference(String clazz) {
        return this.delegate.getServiceReference(clazz);
    }

    public Object getService(ServiceReference reference) {
        return this.delegate.getService(reference);
    }

    public boolean ungetService(ServiceReference reference) {
        return this.delegate.ungetService(reference);
    }

    public File getDataFile(String filename) {
        return this.delegate.getDataFile(filename);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return this.delegate.createFilter(filter);
    }
}

