/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.versioning.check;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.io.IOUtils;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.apache.aries.versioning.check.BundleInfo;
import org.apache.aries.versioning.check.VersionChange;
import org.apache.aries.versioning.utils.BinaryCompatibilityStatus;
import org.apache.aries.versioning.utils.ClassDeclaration;
import org.apache.aries.versioning.utils.FieldDeclaration;
import org.apache.aries.versioning.utils.MethodDeclaration;
import org.apache.aries.versioning.utils.SemanticVersioningClassVisitor;
import org.apache.aries.versioning.utils.SemanticVersioningUtils;
import org.apache.aries.versioning.utils.SerialVersionClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleCompatibility {
    private static final Logger _logger = LoggerFactory.getLogger(BundleCompatibility.class);
    private URLClassLoader oldJarsLoader;
    private URLClassLoader newJarsLoader;
    private String bundleSymbolicName;
    private String bundleElement;
    private boolean bundleVersionCorrect;
    private BundleInfo currentBundle;
    private BundleInfo baseBundle;
    private StringBuilder pkgElements = new StringBuilder();
    private VersionChange bundleChange;
    private final Map<String, VersionChange> packageChanges = new HashMap<String, VersionChange>();

    public BundleCompatibility(String bundleSymbolicName, BundleInfo currentBundle, BundleInfo baseBundle, URLClassLoader oldJarsLoader, URLClassLoader newJarsLoader) {
        this.bundleSymbolicName = bundleSymbolicName;
        this.currentBundle = currentBundle;
        this.baseBundle = baseBundle;
        this.oldJarsLoader = oldJarsLoader;
        this.newJarsLoader = newJarsLoader;
    }

    public VersionChange getBundleChange() {
        return this.bundleChange;
    }

    public Map<String, VersionChange> getPackageChanges() {
        return this.packageChanges;
    }

    public String getBundleElement() {
        return this.bundleElement;
    }

    public StringBuilder getPkgElements() {
        return this.pkgElements;
    }

    public boolean isBundleVersionCorrect() {
        return this.bundleVersionCorrect;
    }

    public BundleCompatibility invoke() throws IOException {
        String reason = null;
        Map<String, PackageContent> currBundleExpPkgContents = this.getAllExportedPkgContents(this.currentBundle);
        boolean pkg_major_change = false;
        boolean pkg_minor_change = false;
        String fatal_package = null;
        if (!currBundleExpPkgContents.isEmpty()) {
            Map<String, PackageContent> baseBundleExpPkgContents = this.getAllExportedPkgContents(this.baseBundle);
            for (Map.Entry<String, PackageContent> pkg : baseBundleExpPkgContents.entrySet()) {
                String pkgName = pkg.getKey();
                Map<String, IFile> baseClazz = pkg.getValue().getClasses();
                Map<String, IFile> baseXsds = pkg.getValue().getXsds();
                PackageContent currPkgContents = currBundleExpPkgContents.get(pkgName);
                if (currPkgContents == null) {
                    pkg_major_change = true;
                    fatal_package = pkgName;
                    _logger.debug("The package " + pkgName + " in the bundle of " + this.bundleSymbolicName + " is no longer to be exported. Major change.");
                    continue;
                }
                Map<String, IFile> curClazz = currPkgContents.getClasses();
                Map<String, IFile> curXsds = currPkgContents.getXsds();
                VersionChangeReason majorChange = new VersionChangeReason();
                VersionChangeReason minorChange = new VersionChangeReason();
                this.visitPackage(pkgName, baseClazz, curClazz, majorChange, minorChange);
                if (!majorChange.isChange()) {
                    this.checkXsdChangesInPkg(pkgName, baseXsds, curXsds, majorChange);
                    if (!majorChange.isChange() && !minorChange.isChange()) {
                        this.checkAdditionalClassOrXsds(pkgName, curClazz, curXsds, minorChange);
                    }
                }
                String oldVersion = pkg.getValue().getPackageVersion();
                String newVersion = currPkgContents.getPackageVersion();
                if (majorChange.isChange()) {
                    this.packageChanges.put(pkgName, new VersionChange(VERSION_CHANGE_TYPE.MAJOR_CHANGE, oldVersion, newVersion));
                    pkg_major_change = true;
                    fatal_package = pkgName;
                    if (!BundleCompatibility.isVersionCorrect(VERSION_CHANGE_TYPE.MAJOR_CHANGE, oldVersion, newVersion)) {
                        this.pkgElements.append(this.getPkgStatusText(pkgName, VERSION_CHANGE_TYPE.MAJOR_CHANGE, oldVersion, newVersion, majorChange.getReason(), majorChange.getChangeClass()));
                    }
                } else if (minorChange.isChange()) {
                    this.packageChanges.put(pkgName, new VersionChange(VERSION_CHANGE_TYPE.MINOR_CHANGE, oldVersion, newVersion));
                    pkg_minor_change = true;
                    if (fatal_package == null) {
                        fatal_package = pkgName;
                    }
                    if (!BundleCompatibility.isVersionCorrect(VERSION_CHANGE_TYPE.MINOR_CHANGE, oldVersion, newVersion)) {
                        this.pkgElements.append(this.getPkgStatusText(pkgName, VERSION_CHANGE_TYPE.MINOR_CHANGE, pkg.getValue().getPackageVersion(), currPkgContents.getPackageVersion(), minorChange.getReason(), minorChange.getChangeClass()));
                    }
                } else {
                    this.packageChanges.put(pkgName, new VersionChange(VERSION_CHANGE_TYPE.NO_CHANGE, oldVersion, newVersion));
                    this.pkgElements.append(this.getPkgStatusText(pkgName, VERSION_CHANGE_TYPE.NO_CHANGE, pkg.getValue().getPackageVersion(), currPkgContents.getPackageVersion(), "", ""));
                }
                this.pkgElements.append("\r\n");
            }
            String oldVersion = this.baseBundle.getBundleManifest().getVersion().toString();
            String newVersion = this.currentBundle.getBundleManifest().getVersion().toString();
            if (pkg_major_change || pkg_minor_change) {
                if (pkg_major_change) {
                    this.bundleChange = new VersionChange(VERSION_CHANGE_TYPE.MAJOR_CHANGE, oldVersion, newVersion);
                    reason = "Some packages have major changes. For an instance, the package " + fatal_package + " has major version changes.";
                    this.bundleElement = this.getBundleStatusText(this.currentBundle.getBundle().getName(), this.bundleSymbolicName, VERSION_CHANGE_TYPE.MAJOR_CHANGE, oldVersion, newVersion, reason);
                    this.bundleVersionCorrect = BundleCompatibility.isVersionCorrect(VERSION_CHANGE_TYPE.MAJOR_CHANGE, oldVersion, newVersion);
                } else if (pkg_minor_change) {
                    this.bundleChange = new VersionChange(VERSION_CHANGE_TYPE.MINOR_CHANGE, oldVersion, newVersion);
                    reason = "Some packages have minor changes. For an instance, the package " + fatal_package + " has minor version changes.";
                    this.bundleElement = this.getBundleStatusText(this.currentBundle.getBundle().getName(), this.bundleSymbolicName, VERSION_CHANGE_TYPE.MINOR_CHANGE, oldVersion, newVersion, reason);
                    this.bundleVersionCorrect = BundleCompatibility.isVersionCorrect(VERSION_CHANGE_TYPE.MINOR_CHANGE, oldVersion, newVersion);
                }
            } else {
                this.bundleChange = new VersionChange(VERSION_CHANGE_TYPE.NO_CHANGE, oldVersion, newVersion);
                this.bundleVersionCorrect = BundleCompatibility.isVersionCorrect(VERSION_CHANGE_TYPE.NO_CHANGE, oldVersion, newVersion);
                if (!this.bundleVersionCorrect) {
                    reason = "The bundle has no version changes.";
                    this.bundleElement = this.getBundleStatusText(this.currentBundle.getBundle().getName(), this.bundleSymbolicName, VERSION_CHANGE_TYPE.NO_CHANGE, oldVersion, newVersion, reason);
                }
            }
        }
        return this;
    }

    private Map<String, PackageContent> getAllExportedPkgContents(BundleInfo currentBundle) {
        String packageExports = currentBundle.getBundleManifest().getRawAttributes().getValue("Export-Package");
        List exportPackageLists = ManifestHeaderProcessor.parseExportString((String)packageExports);
        HashMap<String, PackageContent> exportedPackages = new HashMap<String, PackageContent>();
        if (!exportPackageLists.isEmpty()) {
            File bundleFile = currentBundle.getBundle();
            IDirectory bundleDir = FileSystem.getFSRoot((File)bundleFile);
            for (ManifestHeaderProcessor.NameValuePair exportedPackage : exportPackageLists) {
                String packageName = exportedPackage.getName();
                String packageVersion = (String)exportedPackage.getAttributes().get("version");
                exportedPackages.put(packageName, new PackageContent(packageName, packageVersion));
            }
            List allFiles = bundleDir.listAllFiles();
            for (IFile file : allFiles) {
                String pkgName;
                PackageContent pkgContent;
                String directoryFullPath = file.getName();
                String directoryName = null;
                String fileName = null;
                if (file.isFile() && (file.getName().endsWith(".class") || file.getName().endsWith(".xsd")) && directoryFullPath.lastIndexOf("/") != -1) {
                    directoryName = directoryFullPath.substring(0, directoryFullPath.lastIndexOf("/"));
                    fileName = directoryFullPath.substring(directoryFullPath.lastIndexOf("/") + 1);
                }
                if (directoryName == null || (pkgContent = (PackageContent)exportedPackages.get(pkgName = directoryName.replaceAll("/", "."))) == null) continue;
                if (file.getName().endsWith(".class")) {
                    pkgContent.addClass(fileName, file);
                } else {
                    pkgContent.addXsd(fileName, file);
                }
                exportedPackages.put(pkgName, pkgContent);
            }
        }
        return exportedPackages;
    }

    private String getBundleStatusText(String bundleFileName, String bundleSymbolicName, VERSION_CHANGE_TYPE status, String oldVersionStr, String newVersionStr, String reason) {
        if (!BundleCompatibility.isVersionCorrect(status, oldVersionStr, newVersionStr)) {
            return "The bundle " + bundleSymbolicName + " has the following changes:\r\n" + reason + "\r\nThe bundle version should be " + this.getRecommendedVersion(status, oldVersionStr) + ".";
        }
        return "";
    }

    private void visitPackage(String pkgName, Map<String, IFile> baseClazz, Map<String, IFile> curClazz, VersionChangeReason majorChange, VersionChangeReason minorChange) {
        StringBuilder major_reason = new StringBuilder();
        StringBuilder minor_reason = new StringBuilder();
        boolean is_major_change = false;
        boolean is_minor_change = false;
        String fatal_class = null;
        boolean foundNewAbstract = false;
        block0: for (Map.Entry<String, IFile> file : baseClazz.entrySet()) {
            IFile curFile = curClazz.get(file.getKey());
            String changeClass = file.getValue().getName();
            SemanticVersioningClassVisitor oldcv = this.getVisitor(file.getValue(), this.oldJarsLoader);
            ClassDeclaration cd = oldcv.getClassDeclaration();
            if (cd == null || SemanticVersioningUtils.isPropertyFile(cd)) continue;
            if (curFile == null) {
                major_reason.append("\r\n\r\nThe class/interface " + this.getClassName(changeClass) + " has been deleted from the package.");
                is_major_change = true;
                if (fatal_class != null) continue;
                fatal_class = changeClass;
                continue;
            }
            curClazz.remove(file.getKey());
            SemanticVersioningClassVisitor newcv = this.getVisitor(curFile, this.newJarsLoader);
            ClassDeclaration newcd = newcv.getClassDeclaration();
            BinaryCompatibilityStatus bcs = newcd.getBinaryCompatibleStatus(oldcv.getClassDeclaration());
            if (!bcs.isCompatible()) {
                major_reason.append("\r\n\r\nIn the " + this.getClassName(changeClass) + " class or its supers, the following changes have been made since the last release.");
                for (String reason : bcs) {
                    major_reason.append("\r\n").append(reason);
                }
                is_major_change = true;
                fatal_class = changeClass;
                continue;
            }
            ClassDeclaration oldcd = oldcv.getClassDeclaration();
            Collection<MethodDeclaration> extraMethods = newcd.getExtraMethods(oldcd);
            boolean containsConcrete = false;
            boolean containsAbstract = false;
            boolean abstractClass = newcd.isAbstract();
            StringBuilder subRemarks = new StringBuilder();
            String concreteSubRemarks = null;
            for (MethodDeclaration extraMethod : extraMethods) {
                if (extraMethod.getName().contains("$")) continue;
                if (abstractClass) {
                    if (extraMethod.isAbstract()) {
                        foundNewAbstract = true;
                        containsAbstract = true;
                        subRemarks.append("\r\n" + SemanticVersioningUtils.getReadableMethodSignature(extraMethod.getName(), extraMethod.getDesc()));
                        continue;
                    }
                    containsConcrete = true;
                    concreteSubRemarks = "\r\n" + SemanticVersioningUtils.getReadableMethodSignature(extraMethod.getName(), extraMethod.getDesc());
                    continue;
                }
                containsConcrete = true;
                concreteSubRemarks = "\r\n" + SemanticVersioningUtils.getReadableMethodSignature(extraMethod.getName(), extraMethod.getDesc());
                break;
            }
            if (containsConcrete || containsAbstract) {
                is_minor_change = true;
                if (!is_major_change) {
                    fatal_class = changeClass;
                }
                if (containsAbstract) {
                    minor_reason.append("\r\n\r\nIn the " + this.getClassName(changeClass) + " class or its supers, the following abstract methods have been added since the last release of this bundle.");
                    minor_reason.append((CharSequence)subRemarks);
                } else {
                    minor_reason.append("\r\n\r\nIn the " + this.getClassName(changeClass) + " class or its supers, the following method has been added since the last release of this bundle.");
                    minor_reason.append(concreteSubRemarks);
                }
            }
            if (is_minor_change) continue;
            for (FieldDeclaration field : newcd.getExtraFields(oldcd)) {
                if (!field.isPublic() && !field.isProtected()) continue;
                is_minor_change = true;
                String extraFieldRemarks = "\r\n " + SemanticVersioningUtils.transform(field.getDesc()) + " " + field.getName();
                if (!is_major_change) {
                    fatal_class = changeClass;
                }
                minor_reason.append("\r\n\r\nIn the " + this.getClassName(changeClass) + " class or its supers, the following fields have been added since the last release of this bundle.");
                minor_reason.append(extraFieldRemarks);
                continue block0;
            }
        }
        if (is_major_change) {
            majorChange.update(major_reason.toString(), fatal_class, false);
        }
        if (is_minor_change) {
            minorChange.update(minor_reason.toString(), fatal_class, foundNewAbstract);
        }
    }

    private void checkXsdChangesInPkg(String pkgName, Map<String, IFile> baseXsds, Map<String, IFile> curXsds, VersionChangeReason majorChange) throws IOException {
        for (Map.Entry<String, IFile> file : baseXsds.entrySet()) {
            String oldFileContent;
            IFile curXsd = curXsds.get(file.getKey());
            String changeClass = file.getValue().getName();
            if (curXsd == null) {
                String reason = "In the package " + pkgName + ", The schema file has been deleted: " + file.getKey() + ".";
                majorChange.update(reason, changeClass, false);
                break;
            }
            curXsds.remove(file.getKey());
            String curFileContent = this.readXsdFile(curXsd.open());
            if (curFileContent.equals(oldFileContent = this.readXsdFile(file.getValue().open()))) continue;
            String reason = "In the package " + pkgName + ", The schema file has been updated: " + file.getKey() + ".";
            majorChange.update(reason, changeClass, false);
            break;
        }
    }

    private void checkAdditionalClassOrXsds(String pkgName, Map<String, IFile> curClazz, Map<String, IFile> curXsds, VersionChangeReason minorChange) {
        String reason;
        Collection<IFile> ifiles = curClazz.values();
        for (IFile ifile : ifiles) {
            String changeClass = ifile.getName();
            SemanticVersioningClassVisitor cv = this.getVisitor(ifile, this.newJarsLoader);
            if (cv.getClassDeclaration() == null) continue;
            minorChange.setChange(true);
            if (!minorChange.isChange()) continue;
            reason = "The package " + pkgName + " has gained at least one class : " + this.getClassName(changeClass) + ".";
            minorChange.update(reason, changeClass, false);
            break;
        }
        if (!minorChange.isChange() && !curXsds.isEmpty()) {
            IFile firstXsd = null;
            Iterator<IFile> xsdIterator = curXsds.values().iterator();
            firstXsd = xsdIterator.next();
            reason = "In the package " + pkgName + ", The schema file(s) are added: " + curXsds.keySet() + ".";
            minorChange.update(reason, firstXsd.getName(), false);
        }
    }

    static boolean isVersionCorrect(VERSION_CHANGE_TYPE status, String oldVersionStr, String newVersionStr) {
        boolean versionCorrect = false;
        Version oldVersion = Version.parseVersion((String)oldVersionStr);
        Version newVersion = Version.parseVersion((String)newVersionStr);
        if (status == VERSION_CHANGE_TYPE.MAJOR_CHANGE) {
            if (newVersion.getMajor() > oldVersion.getMajor()) {
                versionCorrect = true;
            }
        } else if (status == VERSION_CHANGE_TYPE.MINOR_CHANGE) {
            if (newVersion.getMajor() > oldVersion.getMajor() || newVersion.getMinor() > oldVersion.getMinor()) {
                versionCorrect = true;
            }
        } else if (newVersion.getMajor() >= oldVersion.getMajor() && newVersion.getMinor() >= oldVersion.getMinor()) {
            versionCorrect = true;
        }
        return versionCorrect;
    }

    private String getRecommendedVersion(VERSION_CHANGE_TYPE status, String oldVersionStr) {
        Version oldVersion = Version.parseVersion((String)oldVersionStr);
        Version recommendedNewVersion = status == VERSION_CHANGE_TYPE.MAJOR_CHANGE ? new Version(oldVersion.getMajor() + 1, 0, 0) : (status == VERSION_CHANGE_TYPE.MINOR_CHANGE ? new Version(oldVersion.getMajor(), oldVersion.getMinor() + 1, 0) : oldVersion);
        return recommendedNewVersion.toString();
    }

    private String getPkgStatusText(String pkgName, VERSION_CHANGE_TYPE status, String oldVersionStr, String newVersionStr, String reason, String key_class) {
        if (!BundleCompatibility.isVersionCorrect(status, oldVersionStr, newVersionStr)) {
            return "The package " + pkgName + " has the following changes:" + reason + "\r\nThe package version should be " + this.getRecommendedVersion(status, oldVersionStr) + ".";
        }
        return "";
    }

    private String getClassName(String fullClassPath) {
        String[] chunks = fullClassPath.split("/");
        String className = chunks[chunks.length - 1];
        className = className.replace(".class", ".java");
        return className;
    }

    private String readXsdFile(InputStream is) {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException ioe) {
            IOUtils.close((Closeable)br);
        }
        return sb.toString();
    }

    private SemanticVersioningClassVisitor getVisitor(IFile file, URLClassLoader loader) {
        SerialVersionClassVisitor sv = new SerialVersionClassVisitor(null);
        SemanticVersioningClassVisitor oldcv = new SemanticVersioningClassVisitor(loader, sv);
        try {
            ClassReader cr = new ClassReader(file.open());
            cr.accept((ClassVisitor)oldcv, 0);
        }
        catch (IOException ioe) {
            _logger.debug("The file " + file + "cannot be opened.");
        }
        return oldcv;
    }

    private static class VersionChangeReason {
        boolean change = false;
        String reason = null;
        String changeClass = null;
        boolean moreAbstractMethod = false;

        private VersionChangeReason() {
        }

        public boolean isMoreAbstractMethod() {
            return this.moreAbstractMethod;
        }

        public boolean isChange() {
            return this.change;
        }

        public void setChange(boolean change) {
            this.change = change;
        }

        public String getReason() {
            return this.reason;
        }

        public String getChangeClass() {
            return this.changeClass;
        }

        public void update(String reason, String changeClass, boolean moreAbstractMethod) {
            this.change = true;
            this.reason = reason;
            this.changeClass = changeClass;
            this.moreAbstractMethod = moreAbstractMethod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageContent {
        private final String packageName;
        private final String packageVersion;
        private final Map<String, IFile> classes = new HashMap<String, IFile>();
        private final Map<String, IFile> xsds = new HashMap<String, IFile>();

        PackageContent(String pkgName, String pkgVersion) {
            this.packageName = pkgName;
            this.packageVersion = pkgVersion;
        }

        public void addClass(String className, IFile file) {
            this.classes.put(className, file);
        }

        public void addXsd(String className, IFile file) {
            this.xsds.put(className, file);
        }

        public Map<String, IFile> getClasses() {
            return this.classes;
        }

        public Map<String, IFile> getXsds() {
            return this.xsds;
        }

        public String getPackageVersion() {
            return this.packageVersion;
        }

        public String getPackageName() {
            return this.packageName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum VERSION_CHANGE_TYPE {
        MAJOR_CHANGE("major"),
        MINOR_CHANGE("minor"),
        NO_CHANGE("no");

        private final String text;

        private VERSION_CHANGE_TYPE(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }
    }
}

