/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.versioning.check;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.io.IOUtils;
import org.apache.aries.util.manifest.BundleManifest;
import org.apache.aries.versioning.check.BundleCompatibility;
import org.apache.aries.versioning.check.BundleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticVersioningChecker {
    private static final Logger _logger = LoggerFactory.getLogger(SemanticVersioningChecker.class);
    private URLClassLoader newJarsLoader;
    private URLClassLoader oldJarsLoader;
    private static final String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";

    public static void checkSemanticVersioning(URL base, URL current, File versioningReport) {
        try {
            File baseDir = new File(base.toURI());
            File currentDir = new File(current.toExternalForm());
            if (baseDir.exists() && currentDir.exists()) {
                new SemanticVersioningChecker().performVersioningCheck(FileSystem.getFSRoot((File)baseDir), FileSystem.getFSRoot((File)currentDir), versioningReport);
            } else {
                _logger.debug("No bundles found to process.");
            }
        }
        catch (URISyntaxException use) {
            _logger.error(use.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void performVersioningCheck(IDirectory baseDir, IDirectory currentDir, File versionStatusFile) {
        FileWriter versionStatusFileWriter = null;
        try {
            versionStatusFileWriter = new FileWriter(versionStatusFile, false);
            Map<String, BundleInfo> currentBundles = this.getBundles(currentDir);
            Map<String, BundleInfo> baseBundles = this.getBundles(baseDir);
            URL[] newJarURLs = this.getListURLs(currentBundles.values()).toArray(new URL[0]);
            this.newJarsLoader = new URLClassLoader(newJarURLs);
            URL[] oldJarURLs = this.getListURLs(baseBundles.values()).toArray(new URL[0]);
            this.oldJarsLoader = new URLClassLoader(oldJarURLs);
            this.writeRecordToWriter(versionStatusFileWriter, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
            this.writeRecordToWriter(versionStatusFileWriter, "<semanticVersioning currentDir= \"" + currentDir + "\" baseDir = \"" + baseDir + "\">");
            for (Map.Entry<String, BundleInfo> entry : currentBundles.entrySet()) {
                String bundleSymbolicName = entry.getKey();
                String bundleElement = null;
                boolean bundleVersionCorrect = true;
                BundleInfo currentBundle = entry.getValue();
                BundleInfo baseBundle = baseBundles.get(bundleSymbolicName);
                StringBuilder pkgElements = new StringBuilder();
                if (baseBundle == null) {
                    _logger.debug("The bundle " + bundleSymbolicName + " has no counterpart in the base. The semantic version validation does not apply to this bundle.");
                } else {
                    BundleCompatibility bundleCompatibility = new BundleCompatibility(bundleSymbolicName, currentBundle, baseBundle, this.oldJarsLoader, this.newJarsLoader).invoke();
                    bundleVersionCorrect = bundleCompatibility.isBundleVersionCorrect();
                    bundleElement = bundleCompatibility.getBundleElement();
                    pkgElements = bundleCompatibility.getPkgElements();
                }
                if (bundleVersionCorrect && pkgElements.length() <= 0) continue;
                this.writeRecordToWriter(versionStatusFileWriter, bundleElement);
                this.writeRecordToWriter(versionStatusFileWriter, pkgElements.toString());
                this.writeRecordToWriter(versionStatusFileWriter, "</bundle>");
            }
            this.writeRecordToWriter(versionStatusFileWriter, "</semanticVersioning>");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            IOUtils.close((Closeable)versionStatusFileWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.close(versionStatusFileWriter);
                    throw throwable;
                }
            }
            IOUtils.close((Closeable)versionStatusFileWriter);
        }
        IOUtils.close((Closeable)versionStatusFileWriter);
    }

    private void writeRecordToWriter(FileWriter fileWriter, String stringToWrite) throws IOException {
        if (fileWriter != null) {
            fileWriter.append(stringToWrite);
            fileWriter.append("\r\n");
        }
    }

    private Map<String, BundleInfo> getBundles(IDirectory ds) {
        HashMap<String, BundleInfo> bundles = new HashMap<String, BundleInfo>();
        List includedFiles = ds.listAllFiles();
        for (IFile ifile : includedFiles) {
            if (!ifile.getName().endsWith(".jar")) continue;
            try {
                BundleManifest manifest = BundleManifest.fromBundle((InputStream)ifile.open());
                if (manifest.getSymbolicName() == null) continue;
                bundles.put(manifest.getSymbolicName(), new BundleInfo(manifest, new File(ifile.toURL().getPath())));
            }
            catch (MalformedURLException mue) {
                _logger.debug("Exception thrown when processing" + ifile.getName(), (Throwable)mue);
            }
            catch (IOException ioe) {
                _logger.debug("Exception thrown when processing" + ifile.getName(), (Throwable)ioe);
            }
        }
        return bundles;
    }

    private Collection<URL> getListURLs(Collection<BundleInfo> bundles) {
        HashSet<URL> urls = new HashSet<URL>();
        try {
            for (BundleInfo bundle : bundles) {
                URL url = bundle.getBundle().toURI().toURL();
                urls.add(url);
            }
        }
        catch (MalformedURLException e) {
            _logger.debug(e.getMessage());
        }
        return urls;
    }
}

