/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.versioning.check;

import org.apache.aries.versioning.check.BundleCompatibility;
import org.osgi.framework.Version;

public class VersionChange {
    private BundleCompatibility.VERSION_CHANGE_TYPE changeType;
    private Version oldVersion;
    private Version newVersion;
    private Version recommendedNewVersion;
    private boolean correct;

    VersionChange(BundleCompatibility.VERSION_CHANGE_TYPE status, String oldVersionStr, String newVersionStr) {
        this.oldVersion = Version.parseVersion((String)oldVersionStr);
        this.newVersion = Version.parseVersion((String)newVersionStr);
        this.recommendedNewVersion = status == BundleCompatibility.VERSION_CHANGE_TYPE.MAJOR_CHANGE ? new Version(this.oldVersion.getMajor() + 1, 0, 0) : (status == BundleCompatibility.VERSION_CHANGE_TYPE.MINOR_CHANGE ? new Version(this.oldVersion.getMajor(), this.oldVersion.getMinor() + 1, 0) : this.oldVersion);
        this.correct = BundleCompatibility.isVersionCorrect(status, oldVersionStr, newVersionStr);
    }

    VersionChange(BundleCompatibility.VERSION_CHANGE_TYPE changeType, Version newVersion, Version oldVersion, Version recommendedNewVersion, boolean correct) {
        this.changeType = changeType;
        this.newVersion = newVersion;
        this.oldVersion = oldVersion;
        this.recommendedNewVersion = recommendedNewVersion;
        this.correct = correct;
    }

    public BundleCompatibility.VERSION_CHANGE_TYPE getChangeType() {
        return this.changeType;
    }

    public Version getNewVersion() {
        return this.newVersion;
    }

    public Version getOldVersion() {
        return this.oldVersion;
    }

    public Version getRecommendedNewVersion() {
        return this.recommendedNewVersion;
    }

    public boolean isCorrect() {
        return this.correct;
    }

    public String toString() {
        return " oldVersion=\"" + this.getOldVersion() + "\" currentVersion=\"" + this.getNewVersion() + "\" recommendedVersion=\"" + this.getRecommendedNewVersion() + "\" correct=\"" + this.isCorrect();
    }
}

