/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.versioning.utils;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.versioning.utils.BinaryCompatibilityStatus;
import org.apache.aries.versioning.utils.FieldDeclaration;
import org.apache.aries.versioning.utils.GenericDeclaration;
import org.apache.aries.versioning.utils.MethodDeclaration;
import org.apache.aries.versioning.utils.SemanticVersioningClassVisitor;
import org.apache.aries.versioning.utils.SemanticVersioningUtils;
import org.apache.aries.versioning.utils.SerialVersionClassVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDeclaration
extends GenericDeclaration {
    private final String superName;
    private final String[] interfaces;
    private final Map<String, FieldDeclaration> fields;
    private final Map<String, Set<MethodDeclaration>> methods;
    private final Map<String, Set<MethodDeclaration>> methodsInUpperChain = new HashMap<String, Set<MethodDeclaration>>();
    private final Map<String, FieldDeclaration> fieldsInUpperChain = new HashMap<String, FieldDeclaration>();
    private final Collection<String> supers = new ArrayList<String>();
    private final URLClassLoader jarsLoader;
    private final SerialVersionClassVisitor serialVisitor;

    public Map<String, FieldDeclaration> getFields() {
        return this.fields;
    }

    public Map<String, FieldDeclaration> getAllFields() {
        HashMap<String, FieldDeclaration> allFields = new HashMap<String, FieldDeclaration>(this.getFields());
        Map<String, FieldDeclaration> fieldsFromSupers = this.getFieldsInUpperChain();
        this.putIfAbsent(allFields, fieldsFromSupers);
        return allFields;
    }

    private void putIfAbsent(Map<String, FieldDeclaration> allFields, Map<String, FieldDeclaration> fieldsFromSupers) {
        for (Map.Entry<String, FieldDeclaration> superFieldEntry : fieldsFromSupers.entrySet()) {
            String fieldName = superFieldEntry.getKey();
            FieldDeclaration fd = superFieldEntry.getValue();
            if (allFields.get(fieldName) != null) continue;
            allFields.put(fieldName, fd);
        }
    }

    public Map<String, Set<MethodDeclaration>> getAllMethods() {
        HashMap<String, Set<MethodDeclaration>> methods = new HashMap<String, Set<MethodDeclaration>>(this.getMethods());
        Map<String, Set<MethodDeclaration>> methodsFromSupers = this.getMethodsInUpperChain();
        for (Map.Entry<String, Set<MethodDeclaration>> superMethodsEntry : methodsFromSupers.entrySet()) {
            Set overloadingMethods = (Set)methods.get(superMethodsEntry.getKey());
            if (overloadingMethods != null) {
                overloadingMethods.addAll((Collection)superMethodsEntry.getValue());
                continue;
            }
            methods.put(superMethodsEntry.getKey(), superMethodsEntry.getValue());
        }
        return methods;
    }

    public Map<String, Set<MethodDeclaration>> getMethods() {
        return this.methods;
    }

    public ClassDeclaration(int access, String name, String signature, String superName, String[] interfaces, URLClassLoader loader, SerialVersionClassVisitor cv) {
        super(access, name, signature);
        this.superName = superName;
        this.interfaces = interfaces;
        this.fields = new HashMap<String, FieldDeclaration>();
        this.methods = new HashMap<String, Set<MethodDeclaration>>();
        this.jarsLoader = loader;
        this.serialVisitor = cv;
    }

    private void getFieldsRecursively(String superClass) {
        if (superClass != null) {
            try {
                SerialVersionClassVisitor cv = new SerialVersionClassVisitor(null);
                SemanticVersioningClassVisitor svc = new SemanticVersioningClassVisitor(this.jarsLoader, cv);
                ClassReader cr = new ClassReader(this.jarsLoader.getResourceAsStream(superClass + ".class"));
                cr.accept((ClassVisitor)svc, 0);
                ClassDeclaration cd = svc.getClassDeclaration();
                if (cd != null) {
                    this.addFieldInUpperChain(cd.getFields());
                    this.getFieldsRecursively(cd.getSuperName());
                    for (String iface : cd.getInterfaces()) {
                        this.getFieldsRecursively(iface);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void getMethodsRecursively(String superClass) {
        if (superClass != null) {
            SerialVersionClassVisitor cv = new SerialVersionClassVisitor(null);
            SemanticVersioningClassVisitor svc = new SemanticVersioningClassVisitor(this.jarsLoader, cv);
            try {
                ClassReader cr = new ClassReader(this.jarsLoader.getResourceAsStream(superClass + ".class"));
                cr.accept((ClassVisitor)svc, 0);
                ClassDeclaration cd = svc.getClassDeclaration();
                if (cd != null) {
                    this.addMethodsInUpperChain(cd.getMethods());
                    this.getMethodsRecursively(cd.getSuperName());
                    for (String iface : cd.getInterfaces()) {
                        this.getMethodsRecursively(iface);
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public Map<String, FieldDeclaration> getFieldsInUpperChain() {
        if (this.fieldsInUpperChain.isEmpty()) {
            this.getFieldsRecursively(this.getSuperName());
            for (String ifs : this.getInterfaces()) {
                this.getFieldsRecursively(ifs);
            }
        }
        return this.fieldsInUpperChain;
    }

    private void addFieldInUpperChain(Map<String, FieldDeclaration> fields) {
        this.putIfAbsent(this.fieldsInUpperChain, fields);
    }

    public Map<String, Set<MethodDeclaration>> getMethodsInUpperChain() {
        if (this.methodsInUpperChain.isEmpty()) {
            this.getMethodsRecursively(this.getSuperName());
            for (String ifs : this.getInterfaces()) {
                this.getMethodsRecursively(ifs);
            }
        }
        return this.methodsInUpperChain;
    }

    private void addMethodsInUpperChain(Map<String, Set<MethodDeclaration>> methods) {
        for (Map.Entry<String, Set<MethodDeclaration>> method : methods.entrySet()) {
            String methodName = method.getKey();
            HashSet mds = new HashSet();
            if (this.methodsInUpperChain.get(methodName) != null) {
                mds.addAll(this.methodsInUpperChain.get(methodName));
            }
            mds.addAll(method.getValue());
            this.methodsInUpperChain.put(methodName, mds);
        }
    }

    public Collection<String> getUpperChainRecursively(String className) {
        HashSet<String> clazz = new HashSet<String>();
        if (className != null) {
            SerialVersionClassVisitor cv = new SerialVersionClassVisitor(null);
            SemanticVersioningClassVisitor svc = new SemanticVersioningClassVisitor(this.jarsLoader, cv);
            try {
                ClassReader cr = new ClassReader(this.jarsLoader.getResourceAsStream(className + ".class"));
                cr.accept((ClassVisitor)svc, 0);
                clazz.add(className);
                if (svc.getClassDeclaration() != null) {
                    String superName = svc.getClassDeclaration().getSuperName();
                    clazz.addAll(this.getUpperChainRecursively(superName));
                    if (svc.getClassDeclaration().getInterfaces() != null) {
                        for (String iface : svc.getClassDeclaration().getInterfaces()) {
                            clazz.addAll(this.getUpperChainRecursively(iface));
                        }
                    }
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return clazz;
    }

    public Collection<String> getAllSupers() {
        if (this.supers.isEmpty()) {
            this.supers.addAll(this.getUpperChainRecursively(this.getSuperName()));
            for (String iface : this.getInterfaces()) {
                this.supers.addAll(this.getUpperChainRecursively(iface));
            }
        }
        return this.supers;
    }

    public String getSuperName() {
        return this.superName;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public void addFields(FieldDeclaration fd) {
        this.fields.put(fd.getName(), fd);
    }

    public void addMethods(MethodDeclaration md) {
        String key = md.getName();
        Set<MethodDeclaration> overloaddingMethods = this.methods.get(key);
        if (overloaddingMethods != null) {
            overloaddingMethods.add(md);
            this.methods.put(key, overloaddingMethods);
        } else {
            HashSet<MethodDeclaration> mds = new HashSet<MethodDeclaration>();
            mds.add(md);
            this.methods.put(key, mds);
        }
    }

    public BinaryCompatibilityStatus getBinaryCompatibleStatus(ClassDeclaration old) {
        BinaryCompatibilityStatus reasons = new BinaryCompatibilityStatus();
        if (old == null) {
            return reasons;
        }
        this.getClassSignatureBinaryCompatibleStatus(old, reasons);
        this.getAllMethodsBinaryCompatibleStatus(old, reasons);
        this.getAllFieldsBinaryCompatibleStatus(old, reasons);
        this.getAllSuperPresentStatus(old, reasons);
        this.getSerializableBackCompatable(old, reasons);
        return reasons;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getAccess());
    }

    private void getClassSignatureBinaryCompatibleStatus(ClassDeclaration originalClass, List<String> reasons) {
        String prefix = " The class " + this.getName();
        if (!originalClass.isAbstract() && this.isAbstract()) {
            reasons.add(prefix + " was not abstract but is changed to be abstract.");
        }
        if (!originalClass.isFinal() && this.isFinal()) {
            reasons.add(prefix + " was not final but is changed to be final.");
        }
        if (originalClass.isPublic() && !this.isPublic()) {
            reasons.add(prefix + " was public but is changed to be non-public.");
        }
    }

    private void getAllFieldsBinaryCompatibleStatus(ClassDeclaration originalClass, List<String> reasons) {
        Map<String, FieldDeclaration> oldFields = originalClass.getAllFields();
        Map<String, FieldDeclaration> newFields = this.getAllFields();
        this.areFieldsBinaryCompatible(oldFields, newFields, reasons);
    }

    private void areFieldsBinaryCompatible(Map<String, FieldDeclaration> oldFields, Map<String, FieldDeclaration> currentFields, List<String> reasons) {
        for (Map.Entry<String, FieldDeclaration> entry : oldFields.entrySet()) {
            FieldDeclaration bef_fd = entry.getValue();
            FieldDeclaration cur_fd = currentFields.get(entry.getKey());
            this.isFieldBinaryCompatible(reasons, bef_fd, cur_fd);
        }
    }

    private boolean isFieldBinaryCompatible(List<String> reasons, FieldDeclaration bef_fd, FieldDeclaration cur_fd) {
        String fieldName = bef_fd.getName();
        boolean compatible = true;
        if (bef_fd.isPublic() || bef_fd.isProtected()) {
            String prefix = "The " + (bef_fd.isPublic() ? "public" : "protected") + " field " + fieldName;
            if (cur_fd == null) {
                reasons.add(prefix + " has been deleted.");
                compatible = false;
            } else {
                if (!bef_fd.isFinal() && cur_fd.isFinal()) {
                    reasons.add(prefix + " was not final but has been changed to be final.");
                    compatible = false;
                }
                if (bef_fd.isStatic() != cur_fd.isStatic()) {
                    reasons.add(prefix + " was static but is changed to be non static or vice versa.");
                    compatible = false;
                }
                if (!this.isFieldTypeSame(bef_fd, cur_fd)) {
                    reasons.add(prefix + " has changed its type.");
                    compatible = false;
                }
                if (SemanticVersioningUtils.isLessAccessible(bef_fd, cur_fd)) {
                    reasons.add(prefix + " becomes less accessible.");
                    compatible = false;
                }
            }
        }
        return compatible;
    }

    private void getSerializableBackCompatable(ClassDeclaration old, List<String> reasons) {
        long curValue;
        long oldValue;
        if (this.getAllSupers().contains("java/io/Serializable") && old.getAllSupers().contains("java/io/Serializable") && !this.getAllSupers().contains("java/lang/Enum") && !old.getAllSupers().contains("java/lang/Enum") && (oldValue = this.getSerialVersionUID(old)) != (curValue = this.getSerialVersionUID(this))) {
            reasons.add("The serializable class is no longer back compatible as the value of SerialVersionUID has changed from " + oldValue + " to " + curValue + ".");
        }
    }

    private long getSerialVersionUID(ClassDeclaration cd) {
        FieldDeclaration serialID = cd.getAllFields().get("serialVersionUID");
        if (serialID != null && serialID.isFinal() && serialID.isStatic() && Type.LONG_TYPE.equals((Object)Type.getType((String)serialID.getDesc()))) {
            if (serialID.getValue() != null) {
                return (Long)serialID.getValue();
            }
            return 0L;
        }
        return cd.getSerialVisitor().getComputeSerialVersionUID();
    }

    private boolean isFieldTypeSame(FieldDeclaration bef_fd, FieldDeclaration cur_fd) {
        boolean descSame = bef_fd.getDesc().equals(cur_fd.getDesc());
        return descSame;
    }

    private void getAllMethodsBinaryCompatibleStatus(ClassDeclaration originalClass, List<String> reasons) {
        Map<String, Set<MethodDeclaration>> oldMethods = originalClass.getAllMethods();
        Map<String, Set<MethodDeclaration>> newMethods = this.getAllMethods();
        this.areMethodsBinaryCompatible(oldMethods, newMethods, reasons);
    }

    private void areMethodsBinaryCompatible(Map<String, Set<MethodDeclaration>> oldMethods, Map<String, Set<MethodDeclaration>> newMethods, List<String> reasons) {
        boolean compatible = true;
        HashMap<String, Collection> extraMethods = new HashMap<String, Collection>();
        for (Map.Entry<String, Set<MethodDeclaration>> entry : newMethods.entrySet()) {
            ArrayList mds = new ArrayList(entry.getValue());
            extraMethods.put(entry.getKey(), mds);
        }
        for (Map.Entry<String, Set<MethodDeclaration>> entry : oldMethods.entrySet()) {
            String methodName = entry.getKey();
            Collection oldMDSigs = entry.getValue();
            Collection newMDSigs = newMethods.get(methodName);
            block2: for (MethodDeclaration md : oldMDSigs) {
                Collection mds;
                String mdName = md.getName();
                String prefix = "The " + SemanticVersioningUtils.getReadableMethodSignature(mdName, md.getDesc());
                if (!md.isProtected() && !md.isPublic()) continue;
                boolean found = false;
                if (newMDSigs != null) {
                    for (MethodDeclaration new_md : newMDSigs) {
                        if (!md.equals(new_md)) continue;
                        found = true;
                        if (!Modifier.isFinal(md.getAccess()) && !Modifier.isStatic(md.getAccess()) && Modifier.isFinal(new_md.getAccess())) {
                            compatible = false;
                            reasons.add(prefix + " was not final but has been changed to be final.");
                        }
                        if (Modifier.isStatic(md.getAccess()) != Modifier.isStatic(new_md.getAccess())) {
                            compatible = false;
                            reasons.add(prefix + " has changed from static to non-static or vice versa.");
                        }
                        if (Modifier.isAbstract(new_md.getAccess()) && !Modifier.isAbstract(md.getAccess())) {
                            compatible = false;
                            reasons.add(prefix + " has changed from non abstract to abstract.");
                        }
                        if (SemanticVersioningUtils.isLessAccessible(md, new_md)) {
                            compatible = false;
                            reasons.add(prefix + " is less accessible.");
                        }
                        if (!compatible) continue;
                        mds = (Collection)extraMethods.get(methodName);
                        mds.remove(new_md);
                        extraMethods.put(methodName, mds);
                        continue block2;
                    }
                }
                if (found) continue;
                if (!this.isMethodInSuperClass(md)) {
                    compatible = false;
                    reasons.add(prefix + " has been deleted or its return type or parameter list has changed.");
                    continue;
                }
                if (newMDSigs == null) continue;
                for (MethodDeclaration new_md : newMDSigs) {
                    if (!md.equals(new_md)) continue;
                    mds = (Collection)extraMethods.get(methodName);
                    mds.remove(new_md);
                    extraMethods.put(methodName, mds);
                }
            }
        }
        for (Map.Entry<String, Set<MethodDeclaration>> entry : extraMethods.entrySet()) {
            for (MethodDeclaration md : (Collection)entry.getValue()) {
                String head = "The " + SemanticVersioningUtils.getReadableMethodSignature(md.getName(), md.getDesc());
                this.isNewMethodSpecialCase(md, head, reasons);
            }
        }
    }

    public Collection<FieldDeclaration> getExtraFields(ClassDeclaration old) {
        Map<String, FieldDeclaration> oldFields = old.getAllFields();
        Map<String, FieldDeclaration> newFields = this.getAllFields();
        HashMap<String, FieldDeclaration> extraFields = new HashMap<String, FieldDeclaration>(newFields);
        for (String key : oldFields.keySet()) {
            extraFields.remove(key);
        }
        return extraFields.values();
    }

    public Collection<MethodDeclaration> getExtraMethods(ClassDeclaration old) {
        HashSet<MethodDeclaration> extraMethods = new HashSet<MethodDeclaration>();
        Map<String, Set<MethodDeclaration>> currMethodsMap = this.getAllMethods();
        Map<String, Set<MethodDeclaration>> oldMethodsMap = old.getAllMethods();
        for (Map.Entry<String, Set<MethodDeclaration>> currMethod : currMethodsMap.entrySet()) {
            String methodName = currMethod.getKey();
            Collection newMethods = currMethod.getValue();
            Collection oldMethods = oldMethodsMap.get(methodName);
            for (MethodDeclaration new_md : newMethods) {
                if (new_md.isPrivate()) continue;
                if (oldMethods == null) {
                    extraMethods.add(new_md);
                    continue;
                }
                if (oldMethods.contains(new_md)) continue;
                extraMethods.add(new_md);
            }
        }
        return extraMethods;
    }

    public boolean isMethodInSuperClass(MethodDeclaration md) {
        String methodName = md.getName();
        Collection overloaddingMethods = this.getMethodsInUpperChain().get(methodName);
        if (overloaddingMethods != null) {
            for (MethodDeclaration value : overloaddingMethods) {
                if (!md.equals(value) || SemanticVersioningUtils.isLessAccessible(md, value) || value.isStatic() != md.isStatic()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNewMethodSpecialCase(MethodDeclaration md, String prefix, List<String> reasons) {
        String methodName = md.getName();
        boolean special = false;
        Collection overloaddingMethods = this.getMethodsInUpperChain().get(methodName);
        if (overloaddingMethods != null) {
            for (MethodDeclaration value : overloaddingMethods) {
                if ("<init>".equals(md.getName()) || !md.equals(value)) continue;
                if (SemanticVersioningUtils.isLessAccessible(value, md)) {
                    special = true;
                    reasons.add(prefix + " is less accessible than the same method in its parent.");
                }
                if (value.isStatic()) {
                    if (md.isStatic()) continue;
                    special = true;
                    reasons.add(prefix + " is non-static but the same method in its parent is static.");
                    continue;
                }
                if (!md.isStatic()) continue;
                special = true;
                reasons.add(prefix + " is static but the same method is its parent is not static.");
            }
        }
        return special;
    }

    private void getAllSuperPresentStatus(ClassDeclaration old, List<String> reasons) {
        Collection<String> oldSupers = old.getAllSupers();
        boolean containsAll = this.getAllSupers().containsAll(oldSupers);
        if (!containsAll) {
            oldSupers.removeAll(this.getAllSupers());
            reasons.add("The superclasses or superinterfaces have stopped being super: " + oldSupers.toString() + ".");
        }
    }

    public SerialVersionClassVisitor getSerialVisitor() {
        return this.serialVisitor;
    }
}

