/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.versioning.utils;

import java.lang.reflect.Modifier;

public abstract class GenericDeclaration {
    private final int access;
    private final String name;
    private final String signature;

    public GenericDeclaration(int access, String name, String signature) {
        int updatedAccess = access;
        if (Modifier.isNative(access)) {
            updatedAccess -= 256;
        }
        if (Modifier.isSynchronized(access)) {
            updatedAccess -= 32;
        }
        this.access = access;
        this.name = name;
        this.signature = signature;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.access);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.access);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.access);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.access);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.access);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.access;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericDeclaration other = (GenericDeclaration)obj;
        if (this.access != other.access) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

