/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.versioning.utils;

import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import org.apache.aries.versioning.utils.ClassDeclaration;
import org.apache.aries.versioning.utils.FieldDeclaration;
import org.apache.aries.versioning.utils.MethodDeclaration;
import org.apache.aries.versioning.utils.SerialVersionClassVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class SemanticVersioningClassVisitor
extends ClassVisitor {
    private ClassDeclaration classDeclaration;
    private boolean needVisit = false;
    private URLClassLoader loader = null;
    private SerialVersionClassVisitor cv = null;

    public SemanticVersioningClassVisitor(URLClassLoader newJarLoader, SerialVersionClassVisitor cv) {
        super(262144);
        this.loader = newJarLoader;
        this.cv = cv;
    }

    public SemanticVersioningClassVisitor(URLClassLoader newJarLoader) {
        super(262144);
        this.loader = newJarLoader;
    }

    public ClassDeclaration getClassDeclaration() {
        return this.classDeclaration;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.cv != null) {
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }
        if (Modifier.isPublic(access) || Modifier.isProtected(access)) {
            this.classDeclaration = new ClassDeclaration(access, name, signature, superName, interfaces, this.loader, this.cv);
            this.needVisit = true;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.cv != null) {
            this.cv.visitField(access, name, desc, signature, value);
        }
        if (this.needVisit) {
            FieldDeclaration fd = new FieldDeclaration(access, name, desc, signature, value);
            this.classDeclaration.addFields(fd);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.cv != null) {
            this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        if (this.needVisit && !"<clinit>".equals(name)) {
            MethodDeclaration md = new MethodDeclaration(access, name, desc, signature, exceptions);
            this.classDeclaration.addMethods(md);
        }
        return null;
    }

    public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
        return null;
    }

    public void visitAttribute(Attribute arg0) {
    }

    public void visitEnd() {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitSource(String arg0, String arg1) {
    }
}

