/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.versioning.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.versioning.utils.ClassDeclaration;
import org.apache.aries.versioning.utils.GenericDeclaration;

public class SemanticVersioningUtils {
    public static final String classExt = ".class";
    public static final String javaExt = ".java";
    public static final String schemaExt = ".xsd";
    public static final String jarExt = ".jar";
    public static final String CONSTRUTOR = "<init>";
    public static final String MAJOR_CHANGE = "major";
    public static final String MINOR_CHANGE = "minor";
    public static final String NO_CHANGE = "no";
    public static final String oneLineBreak = "\r\n";
    public static final String twoLineBreaks = "\r\n\r\n";
    public static final String PROPERTY_FILE_IDENTIFIER = "java/util/ListResourceBundle";
    public static final String CLINIT = "<clinit>";
    public static final String SERIALIZABLE_CLASS_IDENTIFIER = "java/io/Serializable";
    public static final String SERIAL_VERSION_UTD = "serialVersionUID";
    public static final String ENUM_CLASS = "java/lang/Enum";
    public static final int ASM4 = 262144;

    public static boolean isLessAccessible(GenericDeclaration before, GenericDeclaration after) {
        if (before.getAccess() == after.getAccess()) {
            return false;
        }
        return before.isPublic() ? !after.isPublic() : (before.isProtected() ? !after.isPublic() && !after.isProtected() : !before.isPrivate() && after.isPrivate());
    }

    public static String getReadableMethodSignature(String methodName, String methodDesc) {
        int lastBrace = methodDesc.lastIndexOf(")");
        StringBuilder methodSignature = new StringBuilder();
        if (lastBrace == -1) {
            return "method " + methodName + methodDesc;
        }
        String param = methodDesc.substring(1, lastBrace);
        if (CONSTRUTOR.equals(methodName)) {
            methodSignature.append("constructor with parameter list ");
        } else {
            String returnType = methodDesc.substring(lastBrace + 1);
            methodSignature.append("method ");
            methodSignature.append(SemanticVersioningUtils.transform(returnType));
            methodSignature.append(" ");
            methodSignature.append(methodName);
        }
        methodSignature.append("(");
        methodSignature.append(SemanticVersioningUtils.transform(param));
        methodSignature.append(")");
        return methodSignature.toString();
    }

    public static String transform(String asmDesc) {
        String separator = ", ";
        int brkCount = 0;
        StringBuilder returnStr = new StringBuilder();
        while (asmDesc.length() > 0) {
            int index;
            while (asmDesc.startsWith("[")) {
                asmDesc = asmDesc.substring(1);
                ++brkCount;
            }
            while (asmDesc.startsWith("L")) {
                int semiColonIndex = asmDesc.indexOf(";");
                if (semiColonIndex == -1) {
                    return asmDesc;
                }
                returnStr.append(asmDesc.substring(1, semiColonIndex));
                asmDesc = asmDesc.substring(semiColonIndex + 1);
                for (index = 0; index < brkCount; ++index) {
                    returnStr.append("[]");
                }
                brkCount = 0;
                returnStr.append(separator);
            }
            TypeDescriptor td = null;
            while (asmDesc.length() > 0 && (td = TypeDescriptor.fromString(asmDesc.substring(0, 1))) != null) {
                returnStr.append(td.getDesc());
                for (index = 0; index < brkCount; ++index) {
                    returnStr.append("[]");
                }
                brkCount = 0;
                returnStr.append(separator);
                asmDesc = asmDesc.substring(1);
            }
        }
        String finalStr = returnStr.toString();
        if (finalStr.endsWith(separator)) {
            finalStr = finalStr.substring(0, finalStr.lastIndexOf(separator));
        }
        finalStr = finalStr.replaceAll("/", ".");
        return finalStr;
    }

    public static boolean isPropertyFile(ClassDeclaration cd) {
        Collection<String> supers = cd.getAllSupers();
        return supers.contains(PROPERTY_FILE_IDENTIFIER);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeDescriptor {
        I("int"),
        Z("boolean"),
        C("char"),
        B("byte"),
        S("short"),
        F("float"),
        J("long"),
        D("double"),
        V("void");

        String desc;
        private static final Map<String, TypeDescriptor> stringToEnum;

        private TypeDescriptor(String desc) {
            this.desc = desc;
        }

        String getDesc() {
            return this.desc;
        }

        public static TypeDescriptor fromString(String symbol) {
            return stringToEnum.get(symbol);
        }

        static {
            stringToEnum = new HashMap<String, TypeDescriptor>();
            for (TypeDescriptor td : TypeDescriptor.values()) {
                stringToEnum.put(td.toString(), td);
            }
        }
    }
}

