/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.versioning.mojo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.apache.aries.util.manifest.BundleManifest;
import org.apache.aries.versioning.check.BundleCompatibility;
import org.apache.aries.versioning.check.BundleInfo;
import org.apache.aries.versioning.check.VersionChange;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.osgi.framework.Version;

@Mojo(name="version-check", defaultPhase=LifecyclePhase.VERIFY)
public class VersionCheckerMojo
extends AbstractMojo {
    @Parameter(property="aries.oldArtifact")
    private String oldArtifact;
    @Parameter(property="aries.skip.version.check", defaultValue="false")
    private boolean skip;
    @Parameter
    private File newFile;
    @Parameter(property="writePackageInfos", defaultValue="false")
    private boolean writePackageinfos = false;
    @Parameter(defaultValue="${project.basedir}/src/main/java")
    private File source;
    @Component
    private RepositorySystem repository;
    @Component
    protected MavenProject project;
    @Component
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        if (this.newFile == null) {
            this.newFile = this.project.getArtifact().getFile();
        }
        if (this.oldArtifact != null) {
            try {
                BundleInfo newBundle = this.getBundleInfo(this.newFile);
                if (newBundle == null || newBundle.getBundleManifest() == null) {
                    this.getLog().info((CharSequence)(this.newFile + " is not an OSGi bundle, skipping."));
                    return;
                }
                if (null == newBundle.getBundleManifest().getManifestVersion() && null == newBundle.getBundleManifest().getSymbolicName() && Version.emptyVersion.equals((Object)newBundle.getBundleManifest().getVersion())) {
                    this.getLog().info((CharSequence)(this.newFile + " is not an OSGi bundle, skipping."));
                    return;
                }
                BundleInfo oldBundle = this.getBundleInfo(this.resolve(this.oldArtifact));
                String bundleSymbolicName = newBundle.getBundleManifest().getSymbolicName();
                URLClassLoader oldClassLoader = new URLClassLoader(new URL[]{oldBundle.getBundle().toURI().toURL()});
                URLClassLoader newClassLoader = new URLClassLoader(new URL[]{newBundle.getBundle().toURI().toURL()});
                BundleCompatibility bundleCompatibility = new BundleCompatibility(bundleSymbolicName, newBundle, oldBundle, oldClassLoader, newClassLoader);
                bundleCompatibility.invoke();
                String bundleElement = bundleCompatibility.getBundleElement();
                String pkgElement = bundleCompatibility.getPkgElements().toString();
                boolean failed = false;
                if (bundleElement != null && bundleElement.trim().length() > 0) {
                    this.getLog().error((CharSequence)(bundleElement + "\r\n"));
                    failed = true;
                }
                if (pkgElement != null && pkgElement.trim().length() > 0) {
                    this.getLog().error((CharSequence)pkgElement);
                    failed = true;
                }
                if (this.writePackageinfos) {
                    this.writePackageInfos(bundleCompatibility);
                }
                if (failed) {
                    throw new RuntimeException("Semantic Versioning incorrect");
                }
                this.getLog().info((CharSequence)"All package or bundle versions are semanticly versioned correctly.");
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Problem analyzing sources");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem analyzing sources");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackageInfos(BundleCompatibility bundleCompatibility) {
        Map packages = bundleCompatibility.getPackageChanges();
        for (Map.Entry packageChange : packages.entrySet()) {
            VersionChange versionChange = (VersionChange)packageChange.getValue();
            if (versionChange.isCorrect()) continue;
            String packageName = (String)packageChange.getKey();
            String[] bits = packageName.split("\\.");
            File packageInfo = this.source;
            for (String bit : bits) {
                packageInfo = new File(packageInfo, bit);
            }
            packageInfo.mkdirs();
            packageInfo = new File(packageInfo, "packageinfo");
            try {
                FileWriter w = new FileWriter(packageInfo);
                try {
                    w.append("# generated by Apache Aries semantic versioning tool\n");
                    w.append("version " + versionChange.getRecommendedNewVersion().toString() + "\n");
                    w.flush();
                }
                finally {
                    w.close();
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Could not write packageinfo for package " + packageName), (Throwable)e);
            }
        }
    }

    private File resolve(String artifactDescriptor) {
        String[] s = artifactDescriptor.split(":");
        String type = s.length >= 4 ? s[3] : "jar";
        Artifact artifact = this.repository.createArtifact(s[0], s[1], s[2], type);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveRoot(true).setResolveTransitively(false);
        request.setServers(this.session.getRequest().getServers());
        request.setMirrors(this.session.getRequest().getMirrors());
        request.setProxies(this.session.getRequest().getProxies());
        request.setLocalRepository(this.session.getLocalRepository());
        request.setRemoteRepositories(this.session.getRequest().getRemoteRepositories());
        this.repository.resolve(request);
        return artifact.getFile();
    }

    private BundleInfo getBundleInfo(File f) {
        BundleManifest bundleManifest = BundleManifest.fromBundle((File)f);
        return new BundleInfo(bundleManifest, f);
    }
}

