package org.apache.arrow.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.arrow.memory.rounding.RoundingPolicy;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BaseAllocator.Config}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConfig.builder()}.
 */
@Generated(from = "BaseAllocator.Config", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
final class ImmutableConfig extends BaseAllocator.Config {
  private final AllocationManager.Factory allocationManagerFactory;
  private final AllocationListener listener;
  private final long initReservation;
  private final long maxAllocation;
  private final RoundingPolicy roundingPolicy;

  private ImmutableConfig(ImmutableConfig.Builder builder) {
    if (builder.allocationManagerFactory != null) {
      initShim.allocationManagerFactory(builder.allocationManagerFactory);
    }
    if (builder.listener != null) {
      initShim.listener(builder.listener);
    }
    if (builder.initReservationIsSet()) {
      initShim.initReservation(builder.initReservation);
    }
    if (builder.maxAllocationIsSet()) {
      initShim.maxAllocation(builder.maxAllocation);
    }
    if (builder.roundingPolicy != null) {
      initShim.roundingPolicy(builder.roundingPolicy);
    }
    this.allocationManagerFactory = initShim.getAllocationManagerFactory();
    this.listener = initShim.getListener();
    this.initReservation = initShim.getInitReservation();
    this.maxAllocation = initShim.getMaxAllocation();
    this.roundingPolicy = initShim.getRoundingPolicy();
    this.initShim = null;
  }

  private ImmutableConfig(
      AllocationManager.Factory allocationManagerFactory,
      AllocationListener listener,
      long initReservation,
      long maxAllocation,
      RoundingPolicy roundingPolicy) {
    this.allocationManagerFactory = allocationManagerFactory;
    this.listener = listener;
    this.initReservation = initReservation;
    this.maxAllocation = maxAllocation;
    this.roundingPolicy = roundingPolicy;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "BaseAllocator.Config", generator = "Immutables")
  private final class InitShim {
    private byte allocationManagerFactoryBuildStage = STAGE_UNINITIALIZED;
    private AllocationManager.Factory allocationManagerFactory;

    AllocationManager.Factory getAllocationManagerFactory() {
      if (allocationManagerFactoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (allocationManagerFactoryBuildStage == STAGE_UNINITIALIZED) {
        allocationManagerFactoryBuildStage = STAGE_INITIALIZING;
        this.allocationManagerFactory = Objects.requireNonNull(ImmutableConfig.super.getAllocationManagerFactory(), "allocationManagerFactory");
        allocationManagerFactoryBuildStage = STAGE_INITIALIZED;
      }
      return this.allocationManagerFactory;
    }

    void allocationManagerFactory(AllocationManager.Factory allocationManagerFactory) {
      this.allocationManagerFactory = allocationManagerFactory;
      allocationManagerFactoryBuildStage = STAGE_INITIALIZED;
    }

    private byte listenerBuildStage = STAGE_UNINITIALIZED;
    private AllocationListener listener;

    AllocationListener getListener() {
      if (listenerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (listenerBuildStage == STAGE_UNINITIALIZED) {
        listenerBuildStage = STAGE_INITIALIZING;
        this.listener = Objects.requireNonNull(ImmutableConfig.super.getListener(), "listener");
        listenerBuildStage = STAGE_INITIALIZED;
      }
      return this.listener;
    }

    void listener(AllocationListener listener) {
      this.listener = listener;
      listenerBuildStage = STAGE_INITIALIZED;
    }

    private byte initReservationBuildStage = STAGE_UNINITIALIZED;
    private long initReservation;

    long getInitReservation() {
      if (initReservationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (initReservationBuildStage == STAGE_UNINITIALIZED) {
        initReservationBuildStage = STAGE_INITIALIZING;
        this.initReservation = ImmutableConfig.super.getInitReservation();
        initReservationBuildStage = STAGE_INITIALIZED;
      }
      return this.initReservation;
    }

    void initReservation(long initReservation) {
      this.initReservation = initReservation;
      initReservationBuildStage = STAGE_INITIALIZED;
    }

    private byte maxAllocationBuildStage = STAGE_UNINITIALIZED;
    private long maxAllocation;

    long getMaxAllocation() {
      if (maxAllocationBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxAllocationBuildStage == STAGE_UNINITIALIZED) {
        maxAllocationBuildStage = STAGE_INITIALIZING;
        this.maxAllocation = ImmutableConfig.super.getMaxAllocation();
        maxAllocationBuildStage = STAGE_INITIALIZED;
      }
      return this.maxAllocation;
    }

    void maxAllocation(long maxAllocation) {
      this.maxAllocation = maxAllocation;
      maxAllocationBuildStage = STAGE_INITIALIZED;
    }

    private byte roundingPolicyBuildStage = STAGE_UNINITIALIZED;
    private RoundingPolicy roundingPolicy;

    RoundingPolicy getRoundingPolicy() {
      if (roundingPolicyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (roundingPolicyBuildStage == STAGE_UNINITIALIZED) {
        roundingPolicyBuildStage = STAGE_INITIALIZING;
        this.roundingPolicy = Objects.requireNonNull(ImmutableConfig.super.getRoundingPolicy(), "roundingPolicy");
        roundingPolicyBuildStage = STAGE_INITIALIZED;
      }
      return this.roundingPolicy;
    }

    void roundingPolicy(RoundingPolicy roundingPolicy) {
      this.roundingPolicy = roundingPolicy;
      roundingPolicyBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (allocationManagerFactoryBuildStage == STAGE_INITIALIZING) attributes.add("allocationManagerFactory");
      if (listenerBuildStage == STAGE_INITIALIZING) attributes.add("listener");
      if (initReservationBuildStage == STAGE_INITIALIZING) attributes.add("initReservation");
      if (maxAllocationBuildStage == STAGE_INITIALIZING) attributes.add("maxAllocation");
      if (roundingPolicyBuildStage == STAGE_INITIALIZING) attributes.add("roundingPolicy");
      return "Cannot build Config, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code allocationManagerFactory} attribute
   */
  @Override
  AllocationManager.Factory getAllocationManagerFactory() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAllocationManagerFactory()
        : this.allocationManagerFactory;
  }

  /**
   * @return The value of the {@code listener} attribute
   */
  @Override
  AllocationListener getListener() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getListener()
        : this.listener;
  }

  /**
   * @return The value of the {@code initReservation} attribute
   */
  @Override
  long getInitReservation() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getInitReservation()
        : this.initReservation;
  }

  /**
   * @return The value of the {@code maxAllocation} attribute
   */
  @Override
  long getMaxAllocation() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getMaxAllocation()
        : this.maxAllocation;
  }

  /**
   * @return The value of the {@code roundingPolicy} attribute
   */
  @Override
  RoundingPolicy getRoundingPolicy() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRoundingPolicy()
        : this.roundingPolicy;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseAllocator.Config#getAllocationManagerFactory() allocationManagerFactory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for allocationManagerFactory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withAllocationManagerFactory(AllocationManager.Factory value) {
    if (this.allocationManagerFactory == value) return this;
    AllocationManager.Factory newValue = Objects.requireNonNull(value, "allocationManagerFactory");
    return new ImmutableConfig(newValue, this.listener, this.initReservation, this.maxAllocation, this.roundingPolicy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseAllocator.Config#getListener() listener} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for listener
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withListener(AllocationListener value) {
    if (this.listener == value) return this;
    AllocationListener newValue = Objects.requireNonNull(value, "listener");
    return new ImmutableConfig(
        this.allocationManagerFactory,
        newValue,
        this.initReservation,
        this.maxAllocation,
        this.roundingPolicy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseAllocator.Config#getInitReservation() initReservation} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for initReservation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withInitReservation(long value) {
    if (this.initReservation == value) return this;
    return new ImmutableConfig(this.allocationManagerFactory, this.listener, value, this.maxAllocation, this.roundingPolicy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseAllocator.Config#getMaxAllocation() maxAllocation} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for maxAllocation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withMaxAllocation(long value) {
    if (this.maxAllocation == value) return this;
    return new ImmutableConfig(this.allocationManagerFactory, this.listener, this.initReservation, value, this.roundingPolicy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BaseAllocator.Config#getRoundingPolicy() roundingPolicy} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for roundingPolicy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfig withRoundingPolicy(RoundingPolicy value) {
    if (this.roundingPolicy == value) return this;
    RoundingPolicy newValue = Objects.requireNonNull(value, "roundingPolicy");
    return new ImmutableConfig(
        this.allocationManagerFactory,
        this.listener,
        this.initReservation,
        this.maxAllocation,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConfig
        && equalTo((ImmutableConfig) another);
  }

  private boolean equalTo(ImmutableConfig another) {
    return allocationManagerFactory.equals(another.allocationManagerFactory)
        && listener.equals(another.listener)
        && initReservation == another.initReservation
        && maxAllocation == another.maxAllocation
        && roundingPolicy.equals(another.roundingPolicy);
  }

  /**
   * Computes a hash code from attributes: {@code allocationManagerFactory}, {@code listener}, {@code initReservation}, {@code maxAllocation}, {@code roundingPolicy}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + allocationManagerFactory.hashCode();
    h += (h << 5) + listener.hashCode();
    h += (h << 5) + Long.hashCode(initReservation);
    h += (h << 5) + Long.hashCode(maxAllocation);
    h += (h << 5) + roundingPolicy.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Config} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Config{"
        + "allocationManagerFactory=" + allocationManagerFactory
        + ", listener=" + listener
        + ", initReservation=" + initReservation
        + ", maxAllocation=" + maxAllocation
        + ", roundingPolicy=" + roundingPolicy
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link BaseAllocator.Config} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Config instance
   */
  public static ImmutableConfig copyOf(BaseAllocator.Config instance) {
    if (instance instanceof ImmutableConfig) {
      return (ImmutableConfig) instance;
    }
    return ImmutableConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConfig ImmutableConfig}.
   * <pre>
   * ImmutableConfig.builder()
   *    .allocationManagerFactory(org.apache.arrow.memory.AllocationManager.Factory) // optional {@link BaseAllocator.Config#getAllocationManagerFactory() allocationManagerFactory}
   *    .listener(org.apache.arrow.memory.AllocationListener) // optional {@link BaseAllocator.Config#getListener() listener}
   *    .initReservation(long) // optional {@link BaseAllocator.Config#getInitReservation() initReservation}
   *    .maxAllocation(long) // optional {@link BaseAllocator.Config#getMaxAllocation() maxAllocation}
   *    .roundingPolicy(org.apache.arrow.memory.rounding.RoundingPolicy) // optional {@link BaseAllocator.Config#getRoundingPolicy() roundingPolicy}
   *    .build();
   * </pre>
   * @return A new ImmutableConfig builder
   */
  public static ImmutableConfig.Builder builder() {
    return new ImmutableConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConfig ImmutableConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BaseAllocator.Config", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_INIT_RESERVATION = 0x1L;
    private static final long OPT_BIT_MAX_ALLOCATION = 0x2L;
    private long optBits;

    private @Nullable AllocationManager.Factory allocationManagerFactory;
    private @Nullable AllocationListener listener;
    private long initReservation;
    private long maxAllocation;
    private @Nullable RoundingPolicy roundingPolicy;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Config} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BaseAllocator.Config instance) {
      Objects.requireNonNull(instance, "instance");
      allocationManagerFactory(instance.getAllocationManagerFactory());
      listener(instance.getListener());
      initReservation(instance.getInitReservation());
      maxAllocation(instance.getMaxAllocation());
      roundingPolicy(instance.getRoundingPolicy());
      return this;
    }

    /**
     * Initializes the value for the {@link BaseAllocator.Config#getAllocationManagerFactory() allocationManagerFactory} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BaseAllocator.Config#getAllocationManagerFactory() allocationManagerFactory}.</em>
     * @param allocationManagerFactory The value for allocationManagerFactory 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allocationManagerFactory(AllocationManager.Factory allocationManagerFactory) {
      this.allocationManagerFactory = Objects.requireNonNull(allocationManagerFactory, "allocationManagerFactory");
      return this;
    }

    /**
     * Initializes the value for the {@link BaseAllocator.Config#getListener() listener} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BaseAllocator.Config#getListener() listener}.</em>
     * @param listener The value for listener 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder listener(AllocationListener listener) {
      this.listener = Objects.requireNonNull(listener, "listener");
      return this;
    }

    /**
     * Initializes the value for the {@link BaseAllocator.Config#getInitReservation() initReservation} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BaseAllocator.Config#getInitReservation() initReservation}.</em>
     * @param initReservation The value for initReservation 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder initReservation(long initReservation) {
      this.initReservation = initReservation;
      optBits |= OPT_BIT_INIT_RESERVATION;
      return this;
    }

    /**
     * Initializes the value for the {@link BaseAllocator.Config#getMaxAllocation() maxAllocation} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BaseAllocator.Config#getMaxAllocation() maxAllocation}.</em>
     * @param maxAllocation The value for maxAllocation 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maxAllocation(long maxAllocation) {
      this.maxAllocation = maxAllocation;
      optBits |= OPT_BIT_MAX_ALLOCATION;
      return this;
    }

    /**
     * Initializes the value for the {@link BaseAllocator.Config#getRoundingPolicy() roundingPolicy} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BaseAllocator.Config#getRoundingPolicy() roundingPolicy}.</em>
     * @param roundingPolicy The value for roundingPolicy 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder roundingPolicy(RoundingPolicy roundingPolicy) {
      this.roundingPolicy = Objects.requireNonNull(roundingPolicy, "roundingPolicy");
      return this;
    }

    /**
     * Builds a new {@link ImmutableConfig ImmutableConfig}.
     * @return An immutable instance of Config
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConfig build() {
      return new ImmutableConfig(this);
    }

    private boolean initReservationIsSet() {
      return (optBits & OPT_BIT_INIT_RESERVATION) != 0;
    }

    private boolean maxAllocationIsSet() {
      return (optBits & OPT_BIT_MAX_ALLOCATION) != 0;
    }
  }
}
