/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.ByteString;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.StatusRuntimeException;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.stub.StreamObserver;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.ClientAuthHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.StatusUtils;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.FlightServiceGrpc;

public class ClientAuthWrapper {
    public static void doClientAuth(ClientAuthHandler authHandler, FlightServiceGrpc.FlightServiceStub stub) {
        AuthObserver observer = new AuthObserver();
        try {
            observer.responseObserver = stub.handshake(observer);
            authHandler.authenticate(observer.sender, observer.iter);
            if (!observer.sender.errored) {
                observer.responseObserver.onCompleted();
            }
        }
        catch (StatusRuntimeException sre) {
            throw StatusUtils.fromGrpcRuntimeException(sre);
        }
        try {
            if (!((Boolean)observer.completed.get()).booleanValue()) {
                throw new RuntimeException("Unauthenticated");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw StatusUtils.fromThrowable(e.getCause());
        }
    }

    private static class AuthObserver
    implements StreamObserver<Flight.HandshakeResponse> {
        private volatile StreamObserver<Flight.HandshakeRequest> responseObserver;
        private final LinkedBlockingQueue<byte[]> messages = new LinkedBlockingQueue();
        private final AuthSender sender = new AuthSender();
        private CompletableFuture<Boolean> completed;
        private Iterator<byte[]> iter = new Iterator<byte[]>(){

            @Override
            public byte[] next() {
                while (!completed.isDone() || !messages.isEmpty()) {
                    byte[] bytes = (byte[])messages.poll();
                    if (bytes == null) continue;
                    return bytes;
                }
                if (completed.isCompletedExceptionally()) {
                    try {
                        completed.get();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof StatusRuntimeException) {
                            throw (StatusRuntimeException)e.getCause();
                        }
                        throw new RuntimeException(e);
                    }
                }
                throw new IllegalStateException("You attempted to retrieve messages after there were none.");
            }

            @Override
            public boolean hasNext() {
                return !messages.isEmpty();
            }
        };

        public AuthObserver() {
            this.completed = new CompletableFuture();
        }

        @Override
        public void onNext(Flight.HandshakeResponse value) {
            ByteString payload = value.getPayload();
            if (payload != null) {
                this.messages.add(payload.toByteArray());
            }
        }

        @Override
        public void onError(Throwable t) {
            this.completed.completeExceptionally(t);
        }

        @Override
        public void onCompleted() {
            this.completed.complete(true);
        }

        private class AuthSender
        implements ClientAuthHandler.ClientAuthSender {
            private boolean errored = false;

            private AuthSender() {
            }

            @Override
            public void send(byte[] payload) {
                try {
                    AuthObserver.this.responseObserver.onNext(Flight.HandshakeRequest.newBuilder().setPayload(ByteString.copyFrom(payload)).build());
                }
                catch (StatusRuntimeException sre) {
                    throw StatusUtils.fromGrpcRuntimeException(sre);
                }
            }

            @Override
            public void onError(Throwable cause) {
                this.errored = true;
                AuthObserver.this.responseObserver.onError(StatusUtils.toGrpcException(cause));
            }
        }
    }
}

