/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.ByteFunctionHelpers;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.DensityAwareVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueIterableVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.compare.VectorVisitor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.AbstractStructVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.impl.SingleStructReaderImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.ComplexHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.Types;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.CallBack;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.JsonStringHashMap;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.TransferPair;

public class NonNullableStructVector
extends AbstractStructVector
implements ValueIterableVector<Map<String, ?>> {
    private final SingleStructReaderImpl reader = new SingleStructReaderImpl(this);
    protected Field field;
    public int valueCount;
    private transient StructTransferPair ephPair;

    public static NonNullableStructVector empty(String name, BufferAllocator allocator) {
        FieldType fieldType = new FieldType(false, ArrowType.Struct.INSTANCE, null, null);
        return new NonNullableStructVector(name, allocator, fieldType, null, AbstractStructVector.ConflictPolicy.CONFLICT_REPLACE, false);
    }

    public static NonNullableStructVector emptyWithDuplicates(String name, BufferAllocator allocator) {
        FieldType fieldType = new FieldType(false, ArrowType.Struct.INSTANCE, null, null);
        return new NonNullableStructVector(name, allocator, fieldType, null, AbstractStructVector.ConflictPolicy.CONFLICT_APPEND, true);
    }

    public NonNullableStructVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack) {
        this(new Field(name, fieldType, null), allocator, callBack);
    }

    public NonNullableStructVector(Field field, BufferAllocator allocator, CallBack callBack) {
        this(field, allocator, callBack, null, true);
    }

    public NonNullableStructVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack, AbstractStructVector.ConflictPolicy conflictPolicy, boolean allowConflictPolicyChanges) {
        this(new Field(name, fieldType, null), allocator, callBack, conflictPolicy, allowConflictPolicyChanges);
    }

    public NonNullableStructVector(Field field, BufferAllocator allocator, CallBack callBack, AbstractStructVector.ConflictPolicy conflictPolicy, boolean allowConflictPolicyChanges) {
        super(field.getName(), allocator, callBack, conflictPolicy, allowConflictPolicyChanges);
        this.field = field;
        this.valueCount = 0;
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public void copyFrom(int fromIndex, int thisIndex, ValueVector from) {
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        if (this.ephPair == null || this.ephPair.from != from) {
            this.ephPair = (StructTransferPair)from.makeTransferPair(this);
        }
        this.ephPair.copyValueSafe(fromIndex, thisIndex);
    }

    @Override
    public void copyFromSafe(int fromIndex, int thisIndex, ValueVector from) {
        this.copyFrom(fromIndex, thisIndex, from);
    }

    @Override
    protected boolean supportsDirectRead() {
        return true;
    }

    public Iterator<String> fieldNameIterator() {
        return this.getChildFieldNames().iterator();
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        for (ValueVector v : this) {
            v.setInitialCapacity(numRecords);
        }
    }

    @Override
    public void setInitialCapacity(int valueCount, double density) {
        for (ValueVector vector : this) {
            if (vector instanceof DensityAwareVector) {
                ((DensityAwareVector)((Object)vector)).setInitialCapacity(valueCount, density);
                continue;
            }
            vector.setInitialCapacity(valueCount);
        }
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0 || this.size() == 0) {
            return 0;
        }
        long buffer = 0L;
        for (ValueVector v : this) {
            buffer += (long)v.getBufferSize();
        }
        return (int)buffer;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        long bufferSize = 0L;
        for (ValueVector v : this) {
            bufferSize += (long)v.getBufferSizeFor(valueCount);
        }
        return (int)bufferSize;
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.name, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new StructTransferPair(this, new NonNullableStructVector(this.name, allocator, this.field.getFieldType(), callBack, this.getConflictPolicy(), this.allowConflictPolicyChanges), false);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new StructTransferPair(this, (NonNullableStructVector)to);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new StructTransferPair(this, new NonNullableStructVector(ref, allocator, this.field.getFieldType(), this.callBack, this.getConflictPolicy(), this.allowConflictPolicyChanges), false);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new StructTransferPair(this, new NonNullableStructVector(field, allocator, this.callBack, this.getConflictPolicy(), this.allowConflictPolicyChanges), false);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return new StructTransferPair(this, new NonNullableStructVector(field, allocator, callBack, this.getConflictPolicy(), this.allowConflictPolicyChanges), false);
    }

    @Override
    public int getValueCapacity() {
        if (this.size() == 0) {
            return 0;
        }
        return this.getChildren().stream().mapToInt(child -> child.getValueCapacity()).min().getAsInt();
    }

    @Override
    public Map<String, ?> getObject(int index) {
        JsonStringHashMap<String, Object> vv = new JsonStringHashMap<String, Object>();
        for (String child : this.getChildFieldNames()) {
            Object value;
            FieldVector v = this.getChild(child);
            if (v == null || index >= v.getValueCount() || (value = v.getObject(index)) == null) continue;
            vv.put(child, value);
        }
        return vv;
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        int hash = 0;
        for (FieldVector v : this.getChildren()) {
            if (index >= v.getValueCount()) continue;
            hash = ByteFunctionHelpers.combineHash(hash, v.hashCode(index, hasher));
        }
        return hash;
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public int getNullCount() {
        return 0;
    }

    public void get(int index, ComplexHolder holder) {
        this.reader.setPosition(index);
        holder.reader = this.reader;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    public ValueVector getVectorById(int id) {
        return this.getChildByOrdinal(id);
    }

    public <V extends ValueVector> V getVectorById(int id, Class<V> clazz) {
        ValueVector untyped = this.getVectorById(id);
        if (clazz.isInstance(untyped)) {
            return (V)((ValueVector)clazz.cast(untyped));
        }
        throw new ClassCastException("Id " + id + " had the wrong type. Expected " + clazz.getCanonicalName() + " but was " + untyped.getClass().getCanonicalName());
    }

    @Override
    public void setValueCount(int valueCount) {
        for (ValueVector valueVector : this.getChildren()) {
            valueVector.setValueCount(valueCount);
        }
        this.valueCount = valueCount;
    }

    @Override
    public void clear() {
        for (ValueVector valueVector : this.getChildren()) {
            valueVector.clear();
        }
        this.valueCount = 0;
    }

    @Override
    public void reset() {
        for (ValueVector valueVector : this.getChildren()) {
            valueVector.reset();
        }
        this.valueCount = 0;
    }

    @Override
    public Field getField() {
        ArrayList<Field> children = new ArrayList<Field>();
        for (ValueVector valueVector : this.getChildren()) {
            children.add(valueVector.getField());
        }
        if (children.isEmpty() || this.field.getChildren().equals(children)) {
            return this.field;
        }
        this.field = new Field(this.field.getName(), this.field.getFieldType(), children);
        return this.field;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.STRUCT;
    }

    @Override
    public void close() {
        List<FieldVector> vectors = this.getChildren();
        for (FieldVector v : vectors) {
            v.close();
        }
        vectors.clear();
        this.valueCount = 0;
        super.close();
    }

    public void initializeChildrenFromFields(List<Field> children) {
        for (Field field : children) {
            FieldVector vector = (FieldVector)this.add(field.getName(), field.getFieldType());
            vector.initializeChildrenFromFields(field.getChildren());
        }
    }

    public List<FieldVector> getChildrenFromFields() {
        return this.getChildren();
    }

    protected static class StructTransferPair
    implements TransferPair {
        private final TransferPair[] pairs;
        private final NonNullableStructVector from;
        private final NonNullableStructVector to;

        public StructTransferPair(NonNullableStructVector from, NonNullableStructVector to) {
            this(from, to, true);
        }

        protected StructTransferPair(NonNullableStructVector from, NonNullableStructVector to, boolean allocate) {
            this.from = from;
            this.to = to;
            this.pairs = new TransferPair[from.size()];
            this.to.ephPair = null;
            int i = 0;
            for (String child : from.getChildFieldNames()) {
                int preSize = to.size();
                FieldVector vector = from.getChild(child);
                if (vector == null) continue;
                Object newVector = to.addOrGet(child, vector.getField().getFieldType(), vector.getClass());
                if (allocate && to.size() != preSize) {
                    newVector.allocateNew();
                }
                this.pairs[i++] = vector.makeTransferPair((ValueVector)newVector);
            }
        }

        @Override
        public void transfer() {
            for (TransferPair p : this.pairs) {
                p.transfer();
            }
            this.to.valueCount = this.from.valueCount;
            this.from.clear();
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            for (TransferPair p : this.pairs) {
                p.copyValueSafe(from, to);
            }
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            for (TransferPair p : this.pairs) {
                p.splitAndTransfer(startIndex, length);
            }
            this.to.setValueCount(length);
        }
    }
}

