/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica;

import java.util.Properties;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.ConnectionConfigImpl;

public interface ConnectionProperty {
    public String name();

    public String camelName();

    public Object defaultValue();

    public Type type();

    public ConnectionConfigImpl.PropEnv wrap(Properties var1);

    public boolean required();

    public Class valueClass();

    public static enum Type {
        BOOLEAN,
        STRING,
        NUMBER,
        ENUM,
        PLUGIN;


        public Class deduceValueClass(Object defaultValue, Class valueClass) {
            if (valueClass != null) {
                return valueClass;
            }
            if (defaultValue != null) {
                Class<?> c = defaultValue.getClass();
                if (c.isAnonymousClass()) {
                    return c.getSuperclass();
                }
                return c;
            }
            return this.defaultValueClass();
        }

        public boolean valid(Object defaultValue, Class clazz) {
            switch (this) {
                case BOOLEAN: {
                    return clazz == Boolean.class && (defaultValue == null || defaultValue instanceof Boolean);
                }
                case NUMBER: {
                    return Number.class.isAssignableFrom(clazz) && (defaultValue == null || defaultValue instanceof Number);
                }
                case STRING: {
                    return clazz == String.class && (defaultValue == null || defaultValue instanceof String);
                }
                case PLUGIN: {
                    return clazz != null && (defaultValue == null || defaultValue instanceof String);
                }
                case ENUM: {
                    return Enum.class.isAssignableFrom(clazz) && (defaultValue == null || clazz.isInstance(defaultValue));
                }
            }
            throw new AssertionError();
        }

        public Class defaultValueClass() {
            switch (this) {
                case BOOLEAN: {
                    return Boolean.class;
                }
                case NUMBER: {
                    return Number.class;
                }
                case STRING: {
                    return String.class;
                }
                case PLUGIN: {
                    return Object.class;
                }
            }
            throw new AssertionError((Object)"must specify value class for an ENUM");
        }
    }
}

