/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.cms;

import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.cms.KEMRecipientInfo;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.cms.CMSException;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.cms.CMSSecureReadable;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.cms.KEMRecipient;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.cms.KeyTransRecipientId;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.cms.Recipient;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.cms.RecipientInformation;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.cms.RecipientOperator;

public class KEMRecipientInformation
extends RecipientInformation {
    private KEMRecipientInfo info;

    KEMRecipientInformation(KEMRecipientInfo kEMRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(kEMRecipientInfo.getKem(), algorithmIdentifier, cMSSecureReadable);
        this.info = kEMRecipientInfo;
        RecipientIdentifier recipientIdentifier = kEMRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KEMRecipient)recipient).getRecipientOperator(new AlgorithmIdentifier(this.keyEncAlg.getAlgorithm(), this.info), this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

