/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector;

import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ReusableBuffer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.BaseLargeVariableWidthVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.NullCheckingForGet;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueIterableVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.impl.LargeVarCharReaderImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.LargeVarCharHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.Types;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.Text;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.TransferPair;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.validate.ValidateUtil;

public final class LargeVarCharVector
extends BaseLargeVariableWidthVector
implements ValueIterableVector<Text> {
    public LargeVarCharVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.LARGEVARCHAR.getType()), allocator);
    }

    public LargeVarCharVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public LargeVarCharVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new LargeVarCharReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LARGEVARCHAR;
    }

    @Override
    public byte[] get(int index) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            return null;
        }
        long startOffset = this.getStartOffset(index);
        long dataLength = this.getEndOffset(index) - startOffset;
        byte[] result = new byte[(int)dataLength];
        this.valueBuffer.getBytes(startOffset, result, 0, (int)dataLength);
        return result;
    }

    @Override
    public Text getObject(int index) {
        assert (index >= 0);
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            return null;
        }
        Text result = new Text();
        this.read(index, result);
        return result;
    }

    @Override
    public void read(int index, ReusableBuffer<?> buffer) {
        long startOffset = this.getStartOffset(index);
        long dataLength = this.getEndOffset(index) - startOffset;
        buffer.set(this.valueBuffer, startOffset, dataLength);
    }

    public void get(int index, NullableLargeVarCharHolder holder) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.start = this.getStartOffset(index);
        holder.end = this.getEndOffset(index);
        holder.buffer = this.valueBuffer;
    }

    public void set(int index, LargeVarCharHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int dataLength = (int)(holder.end - holder.start);
        long startOffset = this.getStartOffset(index);
        this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, LargeVarCharHolder holder) {
        assert (index >= 0);
        int dataLength = (int)(holder.end - holder.start);
        this.handleSafe(index, dataLength);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        long startOffset = this.getStartOffset(index);
        this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void set(int index, NullableLargeVarCharHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        long startOffset = this.getStartOffset(index);
        if (holder.isSet != 0) {
            int dataLength = (int)(holder.end - holder.start);
            this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
            this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        } else {
            this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset);
        }
        this.lastSet = index;
    }

    public void setSafe(int index, NullableLargeVarCharHolder holder) {
        assert (index >= 0);
        if (holder.isSet != 0) {
            int dataLength = (int)(holder.end - holder.start);
            this.handleSafe(index, dataLength);
            this.fillHoles(index);
            long startOffset = this.getStartOffset(index);
            this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
            this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        } else {
            this.fillHoles(index + 1);
        }
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        this.lastSet = index;
    }

    public void set(int index, Text text) {
        this.set(index, text.getBytes(), 0, (int)text.getLength());
    }

    public void setSafe(int index, Text text) {
        this.setSafe(index, text.getBytes(), 0, (int)text.getLength());
    }

    @Override
    public void validateScalars() {
        for (int i = 0; i < this.getValueCount(); ++i) {
            byte[] value = this.get(i);
            if (value == null) continue;
            ValidateUtil.validateOrThrow(Text.validateUTF8NoThrow(value), "Non-UTF-8 data in VarCharVector at position " + i + ".");
        }
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((LargeVarCharVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        LargeVarCharVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new LargeVarCharVector(ref, LargeVarCharVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new LargeVarCharVector(field, allocator);
        }

        public TransferImpl(LargeVarCharVector to) {
            this.to = to;
        }

        @Override
        public LargeVarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            LargeVarCharVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            LargeVarCharVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, LargeVarCharVector.this);
        }
    }
}

