/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.util.List;
import org.apache.arrow.driver.jdbc.client.ArrowFlightSqlClientHandler;
import org.apache.arrow.driver.jdbc.converter.impl.BinaryAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.BoolAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.DateAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.DecimalAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.DurationAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.FixedSizeBinaryAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.FixedSizeListAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.FloatingPointAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.IntAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.IntervalAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.LargeBinaryAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.LargeListAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.LargeUtf8AvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.ListAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.MapAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.NullAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.StructAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.TimeAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.TimestampAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.UnionAvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.converter.impl.Utf8AvaticaParameterConverter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.TypedValue;

public class AvaticaParameterBinder {
    private final ArrowFlightSqlClientHandler.PreparedStatement preparedStatement;
    private final VectorSchemaRoot parameters;

    public AvaticaParameterBinder(ArrowFlightSqlClientHandler.PreparedStatement preparedStatement, BufferAllocator bufferAllocator) {
        this.parameters = VectorSchemaRoot.create(preparedStatement.getParameterSchema(), bufferAllocator);
        this.preparedStatement = preparedStatement;
    }

    public void bind(List<TypedValue> typedValues) {
        this.bind(typedValues, 0);
    }

    public void bind(List<TypedValue> typedValues, int index) {
        if (this.preparedStatement.getParameterSchema().getFields().size() != typedValues.size()) {
            throw new IllegalStateException(String.format("Prepared statement has %s parameters, but only received %s", this.preparedStatement.getParameterSchema().getFields().size(), typedValues.size()));
        }
        for (int i = 0; i < typedValues.size(); ++i) {
            this.bind(this.parameters.getVector(i), typedValues.get(i), index);
        }
        if (!typedValues.isEmpty()) {
            this.parameters.setRowCount(index + 1);
            this.preparedStatement.setParameters(this.parameters);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bind(FieldVector vector, TypedValue typedValue, int index) {
        try {
            if (typedValue.value == null) {
                if (!vector.getField().isNullable()) throw new UnsupportedOperationException("Can't set null on non-nullable parameter");
                vector.setNull(index);
                return;
            } else {
                if (vector.getField().getType().accept(new BinderVisitor(vector, typedValue, index)).booleanValue()) return;
                throw new UnsupportedOperationException(String.format("Binding to vector type %s is not yet supported", vector.getClass()));
            }
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException(String.format("Binding value of type %s is not yet supported for expected Arrow type %s", new Object[]{typedValue.type, vector.getField().getType()}));
        }
    }

    public static class BinderVisitor
    implements ArrowType.ArrowTypeVisitor<Boolean> {
        private final FieldVector vector;
        private final TypedValue typedValue;
        private final int index;

        public BinderVisitor(FieldVector vector, TypedValue value, int index) {
            this.vector = vector;
            this.typedValue = value;
            this.index = index;
        }

        @Override
        public Boolean visit(ArrowType.Null type) {
            return new NullAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Struct type) {
            return new StructAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.List type) {
            return new ListAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.LargeList type) {
            return new LargeListAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.FixedSizeList type) {
            return new FixedSizeListAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Union type) {
            return new UnionAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Map type) {
            return new MapAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Int type) {
            return new IntAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.FloatingPoint type) {
            return new FloatingPointAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Utf8 type) {
            return new Utf8AvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Utf8View type) {
            throw new UnsupportedOperationException("Utf8View is unsupported");
        }

        @Override
        public Boolean visit(ArrowType.LargeUtf8 type) {
            return new LargeUtf8AvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Binary type) {
            return new BinaryAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.BinaryView type) {
            throw new UnsupportedOperationException("BinaryView is unsupported");
        }

        @Override
        public Boolean visit(ArrowType.LargeBinary type) {
            return new LargeBinaryAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.FixedSizeBinary type) {
            return new FixedSizeBinaryAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Bool type) {
            return new BoolAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Decimal type) {
            return new DecimalAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Date type) {
            return new DateAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Time type) {
            return new TimeAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Timestamp type) {
            return new TimestampAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Interval type) {
            return new IntervalAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.Duration type) {
            return new DurationAvaticaParameterConverter(type).bindParameter(this.vector, this.typedValue, this.index);
        }

        @Override
        public Boolean visit(ArrowType.ListView type) {
            throw new UnsupportedOperationException("Binding is not yet supported for type " + type);
        }
    }
}

