/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationProperties
extends PropertiesConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProperties.class);
    public static final String APPLICATION_PROPERTIES = "application.properties";
    public static final String CLIENT_PROPERTIES = "client.properties";
    private static Configuration INSTANCE = null;

    private ApplicationProperties(URL url) throws ConfigurationException {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration get() throws AtlasException {
        if (INSTANCE != null) return INSTANCE;
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        synchronized (ApplicationProperties.class) {
            if (INSTANCE != null) return INSTANCE;
            Configuration applicationProperties = ApplicationProperties.get(APPLICATION_PROPERTIES);
            Configuration clientProperties = ApplicationProperties.get(CLIENT_PROPERTIES);
            INSTANCE = new CompositeConfiguration(Arrays.asList(applicationProperties, clientProperties));
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static Configuration get(String fileName) throws AtlasException {
        String confLocation = System.getProperty("atlas.conf");
        try {
            URL url = confLocation == null ? ApplicationProperties.class.getResource("/" + fileName) : new File(confLocation, fileName).toURI().toURL();
            LOG.info("Loading {} from {}", (Object)fileName, (Object)url);
            Configuration configuration = new ApplicationProperties(url).interpolatedConfiguration();
            ApplicationProperties.logConfiguration(configuration);
            return configuration;
        }
        catch (Exception e) {
            throw new AtlasException("Failed to load application properties", e);
        }
    }

    private static void logConfiguration(Configuration configuration) {
        if (LOG.isDebugEnabled()) {
            Iterator keys = configuration.getKeys();
            LOG.debug("Configuration loaded:");
            while (keys.hasNext()) {
                String key = (String)keys.next();
                LOG.debug("{} = {}", (Object)key, configuration.getProperty(key));
            }
        }
    }

    public static final Configuration getSubsetConfiguration(Configuration inConf, String prefix) {
        return inConf.subset(prefix);
    }
}

