/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationUtil.class);

    private AuthenticationUtil() {
    }

    public static boolean isKerberosAuthenticationEnabled() {
        boolean isKerberosAuthenticationEnabled = false;
        try {
            isKerberosAuthenticationEnabled = AuthenticationUtil.isKerberosAuthenticationEnabled(ApplicationProperties.get());
        }
        catch (AtlasException e) {
            LOG.error("Error while isKerberosAuthenticationEnabled ", (Throwable)e);
        }
        return isKerberosAuthenticationEnabled;
    }

    public static boolean isKerberosAuthenticationEnabled(Configuration atlasConf) {
        boolean isKerberosAuthenticationEnabled = "true".equalsIgnoreCase(atlasConf.getString("atlas.authentication.method.kerberos"));
        return isKerberosAuthenticationEnabled;
    }

    public static String[] getBasicAuthenticationInput() {
        String username = null;
        String password = null;
        try {
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Enter username for atlas :-");
            username = bufferRead.readLine();
            System.out.println("Enter password for atlas :-");
            password = bufferRead.readLine();
        }
        catch (Exception e) {
            System.out.print("Error while reading ");
            System.exit(1);
        }
        return new String[]{username, password};
    }
}

