/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.springframework.util.DefaultPropertiesPersister;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPropertiesUtil
extends DefaultPropertiesPersister {
    private static Logger logger = Logger.getLogger(XMLPropertiesUtil.class);

    public void loadFromXml(Properties properties, InputStream inputStream) throws IOException {
        try {
            DocumentBuilderFactory xmlDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
            xmlDocumentBuilderFactory.setIgnoringComments(true);
            xmlDocumentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder xmlDocumentBuilder = xmlDocumentBuilderFactory.newDocumentBuilder();
            Document xmlDocument = xmlDocumentBuilder.parse(inputStream);
            xmlDocument.getDocumentElement().normalize();
            NodeList nList = xmlDocument.getElementsByTagName("property");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                String propertyName = "";
                String propertyValue = "";
                if (eElement.getElementsByTagName("name").item(0) != null) {
                    propertyName = eElement.getElementsByTagName("name").item(0).getTextContent().trim();
                }
                if (eElement.getElementsByTagName("value").item(0) != null) {
                    propertyValue = eElement.getElementsByTagName("value").item(0).getTextContent().trim();
                }
                properties.put(propertyName, propertyValue);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error loading : ", (Throwable)e);
        }
    }
}

