/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;

public enum AtlasConfiguration {
    WEBSERVER_MIN_THREADS("atlas.webserver.minthreads", 10),
    WEBSERVER_MAX_THREADS("atlas.webserver.maxthreads", 100),
    WEBSERVER_KEEPALIVE_SECONDS("atlas.webserver.keepalivetimesecs", 60),
    WEBSERVER_QUEUE_SIZE("atlas.webserver.queuesize", 100),
    WEBSERVER_REQUEST_BUFFER_SIZE("atlas.jetty.request.buffer.size", 16192),
    SEARCH_MAX_LIMIT("atlas.search.maxlimit", 10000),
    SEARCH_DEFAULT_LIMIT("atlas.search.defaultlimit", 100);

    private static final Configuration APPLICATION_PROPERTIES;
    private final String propertyName;
    private final Object defaultValue;

    private AtlasConfiguration(String propertyName, Object defaultValue) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
    }

    public int getInt() {
        return APPLICATION_PROPERTIES.getInt(this.propertyName, Integer.valueOf(this.defaultValue.toString()).intValue());
    }

    public long getLong() {
        return APPLICATION_PROPERTIES.getLong(this.propertyName, Long.valueOf(this.defaultValue.toString()).longValue());
    }

    public String getString() {
        return APPLICATION_PROPERTIES.getString(this.propertyName, this.defaultValue.toString());
    }

    public Object get() {
        Object value = APPLICATION_PROPERTIES.getProperty(this.propertyName);
        return value == null ? this.defaultValue : value;
    }

    static {
        try {
            APPLICATION_PROPERTIES = ApplicationProperties.get();
        }
        catch (AtlasException e) {
            throw new RuntimeException(e);
        }
    }
}

