/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.service.Service;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;

@AtlasService
@Profile(value={"!test"})
public class Services {
    public static final Logger LOG = LoggerFactory.getLogger(Services.class);
    private final List<Service> services;
    private final Configuration configuration;

    @Inject
    public Services(List<Service> services, Configuration configuration) {
        this.services = services;
        this.configuration = configuration;
    }

    @PostConstruct
    public void start() {
        if (this.configuration.getBoolean("atlas.services.enabled", true)) {
            try {
                for (Service service : this.services) {
                    LOG.info("Starting service {}", (Object)service.getClass().getName());
                    service.start();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @PreDestroy
    public void stop() {
        if (this.configuration.getBoolean("atlas.services.enabled", true)) {
            for (int idx = this.services.size() - 1; idx >= 0; --idx) {
                Service service = this.services.get(idx);
                LOG.info("Stopping service {}", (Object)service.getClass().getName());
                try {
                    service.stop();
                    continue;
                }
                catch (Throwable e) {
                    LOG.warn("Error stopping service {}", (Object)service.getClass().getName(), (Object)e);
                }
            }
        }
    }
}

