/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository;

import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;

public final class Constants {
    public static final String INTERNAL_PROPERTY_KEY_PREFIX = "__";
    public static final String RELATIONSHIP_PROPERTY_KEY_PREFIX = "_r";
    public static final String GUID_PROPERTY_KEY = "__guid";
    public static final String RELATIONSHIP_GUID_PROPERTY_KEY = "_r__guid";
    public static final String ENTITY_TYPE_PROPERTY_KEY = "__typeName";
    public static final String TYPE_NAME_INTERNAL = "__internal";
    public static final String SUPER_TYPES_PROPERTY_KEY = "__superTypeNames";
    public static final String ENTITY_TEXT_PROPERTY_KEY = "entityText";
    public static final String TYPE_CATEGORY_PROPERTY_KEY = Constants.getTypePropertyKey("__type.category");
    public static final String VERTEX_TYPE_PROPERTY_KEY = Constants.getTypePropertyKey("__type");
    public static final String TYPENAME_PROPERTY_KEY = Constants.getTypePropertyKey("__type.name");
    public static final String TYPEDESCRIPTION_PROPERTY_KEY = Constants.getTypePropertyKey("__type.description");
    public static final String TYPEVERSION_PROPERTY_KEY = Constants.getTypePropertyKey("__type.version");
    public static final String TYPEOPTIONS_PROPERTY_KEY = Constants.getTypePropertyKey("__type.options");
    public static final String RELATIONSHIPTYPE_END1_KEY = "endDef1";
    public static final String RELATIONSHIPTYPE_END2_KEY = "endDef2";
    public static final String RELATIONSHIPTYPE_CATEGORY_KEY = "relationshipCategory";
    public static final String RELATIONSHIPTYPE_TAG_PROPAGATION_KEY = "tagPropagation";
    public static final String RELATIONSHIPTYPE_BLOCKED_PROPAGATED_CLASSIFICATIONS_KEY = "blockedPropagatedClassifications";
    public static final String TRAIT_NAMES_PROPERTY_KEY = "__traitNames";
    public static final String PROPAGATED_TRAIT_NAMES_PROPERTY_KEY = "__propagatedTraitNames";
    public static final String VERSION_PROPERTY_KEY = "__version";
    public static final String STATE_PROPERTY_KEY = "__state";
    public static final String CREATED_BY_KEY = "__createdBy";
    public static final String MODIFIED_BY_KEY = "__modifiedBy";
    public static final String TIMESTAMP_PROPERTY_KEY = "__timestamp";
    public static final String MODIFICATION_TIMESTAMP_PROPERTY_KEY = "__modificationTimestamp";
    public static final String BACKING_INDEX = "search";
    public static final String VERTEX_INDEX = "vertex_index";
    public static final String EDGE_INDEX = "edge_index";
    public static final String FULLTEXT_INDEX = "fulltext_index";
    public static final String QUALIFIED_NAME = "Referenceable.qualifiedName";
    public static final String TYPE_NAME_PROPERTY_KEY = "__typeName";
    public static final String INDEX_SEARCH_MAX_RESULT_SET_SIZE = "atlas.graph.index.search.max-result-set-size";
    public static final String INDEX_SEARCH_TYPES_MAX_QUERY_STR_LENGTH = "atlas.graph.index.search.types.max-query-str-length";
    public static final String INDEX_SEARCH_TAGS_MAX_QUERY_STR_LENGTH = "atlas.graph.index.search.tags.max-query-str-length";
    public static final String INDEX_SEARCH_VERTEX_PREFIX_PROPERTY = "atlas.graph.index.search.vertex.prefix";
    public static final String INDEX_SEARCH_VERTEX_PREFIX_DEFAULT = "$v$";
    public static final String MAX_FULLTEXT_QUERY_STR_LENGTH = "atlas.graph.fulltext-max-query-str-length";
    public static final String MAX_DSL_QUERY_STR_LENGTH = "atlas.graph.dsl-max-query-str-length";
    public static final String ATTRIBUTE_NAME_GUID = "guid";
    public static final String ATTRIBUTE_NAME_TYPENAME = "typeName";
    public static final String ATTRIBUTE_NAME_SUPERTYPENAMES = "superTypeNames";
    public static final String ATTRIBUTE_NAME_STATE = "state";
    public static final String ATTRIBUTE_NAME_VERSION = "version";
    public static final String TEMP_STRUCT_NAME_PREFIX = "__tempQueryResultStruct";
    public static final String CLASSIFICATION_ENTITY_GUID = "__entityGuid";
    public static final String CLASSIFICATION_VALIDITY_PERIODS_KEY = "__validityPeriods";
    public static final String CLASSIFICATION_VERTEX_PROPAGATE_KEY = "__propagate";
    public static final String CLASSIFICATION_VERTEX_NAME_KEY = "__typeName";
    public static final String CLASSIFICATION_EDGE_NAME_PROPERTY_KEY = "__name";
    public static final String CLASSIFICATION_EDGE_IS_PROPAGATED_PROPERTY_KEY = "__isPropagated";
    public static final String CLASSIFICATION_EDGE_STATE_PROPERTY_KEY = "__state";
    public static final String CLASSIFICATION_LABEL = "classifiedAs";
    public static final String TERM_ASSIGNMENT_LABEL = "r:AtlasGlossarySemanticAssignment";
    public static final String ATTRIBUTE_INDEX_PROPERTY_KEY = "__index";
    public static final String ATTRIBUTE_KEY_PROPERTY_KEY = "__key";
    public static final String VERTEX_ID_IN_IMPORT_KEY = "__vIdInImport";
    public static final String EDGE_ID_IN_IMPORT_KEY = "__eIdInImport";

    private Constants() {
    }

    private static String getTypePropertyKey(String defaultKey) {
        try {
            Configuration configuration = ApplicationProperties.get();
            if (configuration.containsKey("atlas.graph.index.search.backend") && configuration.getString("atlas.graph.index.search.backend").equals("elasticsearch")) {
                return defaultKey.replaceAll("\\.", "_");
            }
            return defaultKey;
        }
        catch (AtlasException e) {
            return defaultKey;
        }
    }
}

