/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import java.util.List;
import org.apache.atlas.repository.graphdb.AtlasCardinality;
import org.apache.atlas.repository.graphdb.AtlasEdgeDirection;
import org.apache.atlas.repository.graphdb.AtlasPropertyKey;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusPropertyKey;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.PropertyKey;

public final class AtlasJanusObjectFactory {
    private AtlasJanusObjectFactory() {
    }

    public static Direction createDirection(AtlasEdgeDirection dir) {
        switch (dir) {
            case IN: {
                return Direction.IN;
            }
            case OUT: {
                return Direction.OUT;
            }
            case BOTH: {
                return Direction.BOTH;
            }
        }
        throw new RuntimeException("Unrecognized direction: " + dir);
    }

    public static Cardinality createCardinality(AtlasCardinality cardinality) {
        switch (cardinality) {
            case SINGLE: {
                return Cardinality.SINGLE;
            }
            case LIST: {
                return Cardinality.LIST;
            }
            case SET: {
                return Cardinality.SET;
            }
        }
        throw new IllegalStateException("Unrecognized cardinality: " + cardinality);
    }

    public static PropertyKey createPropertyKey(AtlasPropertyKey key) {
        return ((AtlasJanusPropertyKey)key).getWrappedPropertyKey();
    }

    public static PropertyKey[] createPropertyKeys(List<AtlasPropertyKey> keys) {
        PropertyKey[] ret = new PropertyKey[keys.size()];
        int i = 0;
        for (AtlasPropertyKey key : keys) {
            ret[i] = AtlasJanusObjectFactory.createPropertyKey(key);
            ++i;
        }
        return ret;
    }
}

